/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.table.Filter;
import tecgraf.javautils.gui.table.FilteredTableListener;

public class FilteredTableModel
implements TableModel,
TableModelListener {
    private EventListenerList listenerList;
    private TableModel model;
    private List<Integer> filteredRows;
    private Filter filter;

    public FilteredTableModel(TableModel model, Filter filter) {
        if (model == null) {
            throw new IllegalArgumentException("model == null");
        }
        this.model = model;
        this.filter = filter;
        this.filteredRows = new ArrayList<Integer>();
        this.listenerList = new EventListenerList();
        this.setFilteredRows();
        model.addTableModelListener(this);
    }

    private void setFilteredRows() {
        this.filteredRows.clear();
        for (int rowIndex = 0; rowIndex < this.model.getRowCount(); ++rowIndex) {
            if (this.filter != null && !this.filter.includes(this.model, rowIndex)) continue;
            this.filteredRows.add(new Integer(rowIndex));
        }
    }

    public void filter() {
        this.setFilteredRows();
        this.fireTableFiltered();
        this.fireTableChanged(new TableModelEvent(this));
    }

    private void fireTableFiltered() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FilteredTableListener.class) continue;
            ((FilteredTableListener)listeners[i + 1]).tableFiltered(this);
        }
    }

    private void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    public TableModel getModel() {
        return this.model;
    }

    @Override
    public int getRowCount() {
        return this.filteredRows.size();
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public Object getValueAt(int viewRowIndex, int columnIndex) {
        int modelIndex = this.filteredRows.get(viewRowIndex);
        return this.model.getValueAt(modelIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object value, int viewRowIndex, int columnIndex) {
        int modelRowIndex = this.filteredRows.get(viewRowIndex);
        this.model.setValueAt(value, modelRowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.model.getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.model.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.model.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.filter();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void addFilteredTableListener(FilteredTableListener l) {
        this.listenerList.add(FilteredTableListener.class, l);
    }

    public void removeFilteredTableListener(FilteredTableListener l) {
        this.listenerList.remove(FilteredTableListener.class, l);
    }

    public int getFilteredRowIndex(int modelRowIndex) {
        if (modelRowIndex < 0 || modelRowIndex > this.model.getRowCount() - 1) {
            return -1;
        }
        int size = this.filteredRows.size();
        for (int i = 0; i < size; ++i) {
            Integer modelIndex = this.filteredRows.get(i);
            if (!modelIndex.equals(modelRowIndex)) continue;
            return i;
        }
        return -1;
    }

    public int getModelRowIndex(int filteredRowIndex) {
        if (filteredRowIndex < 0 || filteredRowIndex > this.getRowCount() - 1) {
            return -1;
        }
        return this.filteredRows.get(filteredRowIndex);
    }
}

