/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.runner.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class RunnerErrorDialog
extends JDialog {
    private static final Color BACKGROUND_COLOR = UIManager.getDefaults().getColor("TextField.inactiveBackground");
    private static final int COLUMNS = 80;
    private static final int MESSAGE_ROWS = 4;
    private static final int STACK_ROWS = 14;
    protected final Throwable error;
    protected final String[] additionalInfo;

    public RunnerErrorDialog(Window owner, String title, Throwable error, String[] additionalInfo) {
        super(owner, title);
        this.error = error;
        this.additionalInfo = additionalInfo;
        this.setDefaultCloseOperation(2);
        this.createComponents();
    }

    private void createComponents() {
        JLabel messageLabel = new JLabel("Message:");
        JScrollPane msgScrollPane = this.createMessagePane();
        JLabel stackTraceLabel = new JLabel("Execution Stack:");
        JScrollPane stackTraceScroll = this.createStackPane();
        JLabel label = new JLabel("Execution Info:");
        JScrollPane scrollPane = this.createInfoPane();
        this.setLayout(new GridBagLayout());
        GridBagConstraints labelGBC = new GridBagConstraints();
        labelGBC.gridx = 0;
        labelGBC.gridy = -1;
        labelGBC.anchor = 17;
        labelGBC.insets = new Insets(5, 6, 0, 10);
        GridBagConstraints fieldGBC = new GridBagConstraints();
        fieldGBC.gridx = 0;
        fieldGBC.gridy = -1;
        fieldGBC.fill = 1;
        fieldGBC.insets = new Insets(3, 10, 5, 10);
        this.add((Component)label, labelGBC);
        this.add((Component)scrollPane, fieldGBC);
        this.add((Component)messageLabel, labelGBC);
        this.add((Component)msgScrollPane, fieldGBC);
        this.add((Component)stackTraceLabel, labelGBC);
        this.add((Component)stackTraceScroll, fieldGBC);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private JScrollPane createInfoPane() {
        int rows = 3;
        if (this.additionalInfo != null && this.additionalInfo.length != 0) {
            rows = this.additionalInfo.length + 1;
        }
        JTextArea additionalInfoTextArea = new JTextArea(rows, 80);
        additionalInfoTextArea.setEditable(false);
        additionalInfoTextArea.setBackground(BACKGROUND_COLOR);
        additionalInfoTextArea.setText(this.createAdditionalInfoText());
        return new JScrollPane(additionalInfoTextArea);
    }

    private JScrollPane createStackPane() {
        JTextArea stackTraceTextArea = new JTextArea(this.getStackTraceText());
        stackTraceTextArea.setColumns(80);
        stackTraceTextArea.setRows(14);
        stackTraceTextArea.setEditable(false);
        stackTraceTextArea.setBackground(BACKGROUND_COLOR);
        return new JScrollPane(stackTraceTextArea);
    }

    private JScrollPane createMessagePane() {
        JTextArea messageTextArea = new JTextArea(this.error.getLocalizedMessage());
        messageTextArea.setColumns(80);
        messageTextArea.setRows(4);
        messageTextArea.setEditable(false);
        messageTextArea.setBackground(BACKGROUND_COLOR);
        return new JScrollPane(messageTextArea);
    }

    private String createAdditionalInfoText() {
        StringBuilder info = new StringBuilder();
        if (this.additionalInfo != null && this.additionalInfo.length > 0) {
            for (String anAdditionalInfo : this.additionalInfo) {
                info.append(anAdditionalInfo);
                info.append("\n");
            }
        }
        return info.toString();
    }

    private String getStackTraceText() {
        StringWriter writer = new StringWriter();
        this.error.printStackTrace(new PrintWriter(writer));
        return ((Object)writer).toString();
    }
}

