package snakegame.map;

import java.awt.Color;

/**
 * Enumerao que define os tipos de objetos que esto no mapa.
 * 
 * @author Tecgraf/PUC-Rio
 */
public enum Cell {

  /** Espao vazio. */
  EMPTY(Color.WHITE),

  /** Espao ocupado pela cobra. */
  SNAKE(Color.BLACK),

  /** Espao ocupado pela comida. */
  FOOD(Color.RED);

  /** Cor. */
  public final Color color;

  /**
   * Construtor.
   * 
   * @param color cor.
   */
  Cell(Color color) {
    this.color = color;
  }
}
