package snakegame.session;

import java.awt.Dimension;

/**
 * Constantes que definem o tamanho do mapa.
 * 
 * @author Tecgraf/PUC-Rio
 */
public enum MapSize {

  /** Mapa 20 X 20. */
  SMALL(20, new Dimension(400, 400)),

  /** Mapa 40 X 40. */
  LARGE(40, new Dimension(800, 800));

  /** Tamanho do mapa. */
  public final int size;

  /** Tamanho aconselhado para o frame principal. */
  public final Dimension dimension;

  /**
   * Construtor.
   * 
   * @param size tamanho do mapa.
   * @param dimension tamanho do frame principal.
   */
  MapSize(int size, Dimension dimension) {
    this.size = size;
    this.dimension = dimension;
  }
}
