/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.field;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import tecgraf.javautils.gui.field.AbstractRegexField;
import tecgraf.javautils.gui.field.RegexDocument;

public class GenericField
extends AbstractRegexField {
    public GenericField(String regex) {
        this(regex, null);
    }

    public GenericField(String regex, String validateRegex) {
        this.setDocument(new GenericDocument(regex, validateRegex));
    }

    @Override
    public boolean isValidValue() {
        GenericDocument document = (GenericDocument)this.getDocument();
        return document.isValid();
    }

    @Override
    public void setDocument(Document doc) {
        if (doc != null && doc instanceof GenericDocument) {
            super.setDocument(doc);
        }
    }

    private static class GenericDocument
    extends RegexDocument {
        private String validateRegex;

        public GenericDocument(String regex, String validateRegex) {
            super(regex);
            this.validateRegex = validateRegex;
        }

        @Override
        protected Object getValue() {
            try {
                return this.getText(0, this.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                return null;
            }
        }

        public boolean isValid() {
            if (this.validateRegex == null) {
                return true;
            }
            String text = (String)this.getValue();
            if (text != null) {
                return text.matches(this.validateRegex);
            }
            return false;
        }
    }
}

