/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.core.string;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class StringUtils {
    private static Comparator<String> plainSortComparator;
    private static Collator plainSortCollator;
    private static Map<Character, Character> ACCENT_REMOVAL_MAP;

    public static Collator getPlainSortCollator() {
        if (plainSortCollator == null) {
            plainSortCollator = (Collator)Collator.getInstance().clone();
            plainSortCollator.setStrength(2);
        }
        return plainSortCollator;
    }

    public static Comparator<String> getPlainSortComparator() {
        if (plainSortComparator == null) {
            plainSortComparator = new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return StringUtils.compare(o1, o2);
                }
            };
        }
        return plainSortComparator;
    }

    public static int compare(String s1, String s2) {
        return StringUtils.getPlainSortCollator().compare(s1, s2);
    }

    public static String[] sort(String[] array) {
        Arrays.sort(array, StringUtils.getPlainSortComparator());
        return array;
    }

    public static String capitalize(String name) {
        if (StringUtils.isEmptyString(name)) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String removeAccents(String str) {
        char[] cStr = str.toCharArray();
        for (int i = 0; i < cStr.length; ++i) {
            Character c = ACCENT_REMOVAL_MAP.get(Character.valueOf(cStr[i]));
            if (c == null) continue;
            cStr[i] = c.charValue();
        }
        return new String(cStr);
    }

    public static boolean isEmptyString(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static char lastChar(String str) {
        if (str.isEmpty()) {
            throw new IllegalArgumentException("string vazia");
        }
        return str.charAt(str.length() - 1);
    }

    public static String concat(char separator, boolean separatorAtEnd, String ... strings) {
        StringBuffer buffer = new StringBuffer(strings[0] == null ? "" : strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            buffer.append(separator);
            buffer.append(strings[i] == null ? "" : strings[i]);
        }
        if (separatorAtEnd) {
            buffer.append(separator);
        }
        return buffer.toString();
    }

    static {
        ACCENT_REMOVAL_MAP = new HashMap<Character, Character>();
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e1'), Character.valueOf('a'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e0'), Character.valueOf('a'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e3'), Character.valueOf('a'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e2'), Character.valueOf('a'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c1'), Character.valueOf('A'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c0'), Character.valueOf('A'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c3'), Character.valueOf('A'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c2'), Character.valueOf('A'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e9'), Character.valueOf('e'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e8'), Character.valueOf('e'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00ea'), Character.valueOf('e'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c9'), Character.valueOf('E'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c8'), Character.valueOf('E'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00ca'), Character.valueOf('E'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00ed'), Character.valueOf('i'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00ec'), Character.valueOf('i'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00cd'), Character.valueOf('i'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00cc'), Character.valueOf('i'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00f3'), Character.valueOf('o'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00f2'), Character.valueOf('o'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00f5'), Character.valueOf('o'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00f4'), Character.valueOf('o'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00d3'), Character.valueOf('O'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00d2'), Character.valueOf('O'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00d5'), Character.valueOf('O'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00d4'), Character.valueOf('O'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00fa'), Character.valueOf('u'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00f9'), Character.valueOf('u'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00da'), Character.valueOf('u'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00d9'), Character.valueOf('u'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e7'), Character.valueOf('c'));
        ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c7'), Character.valueOf('C'));
    }
}

