/*
 * Decompiled with CFR 0.152.
 */
package snakegame.algorithm.euclidean;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import snakegame.algorithm.IMoveAlgorithm;
import snakegame.algorithm.util.DeltaDouble;
import snakegame.algorithm.util.Util;
import snakegame.map.Direction;

public class EuclideanAlgorithm
implements IMoveAlgorithm {
    @Override
    public Direction whereShouldIGo(List<Point> snake, Direction direction, Point food, int rows, int columns) {
        Point right = Util.lookahead(snake, Direction.RIGHT, rows, columns);
        Point left = Util.lookahead(snake, Direction.LEFT, rows, columns);
        Point down = Util.lookahead(snake, Direction.DOWN, rows, columns);
        Point up = Util.lookahead(snake, Direction.UP, rows, columns);
        Double rightDistance = this.distance(right, food);
        Double leftDistance = this.distance(left, food);
        Double downDistance = this.distance(down, food);
        Double upDistance = this.distance(up, food);
        Double minDistance = Math.min(rightDistance, leftDistance);
        minDistance = Math.min(minDistance, upDistance);
        minDistance = Math.min(minDistance, downDistance);
        ArrayList<DeltaDouble> candidates = new ArrayList<DeltaDouble>();
        candidates.add(new DeltaDouble(rightDistance, Direction.RIGHT));
        candidates.add(new DeltaDouble(leftDistance, Direction.LEFT));
        candidates.add(new DeltaDouble(upDistance, Direction.UP));
        candidates.add(new DeltaDouble(downDistance, Direction.DOWN));
        Collections.sort(candidates);
        return ((DeltaDouble)candidates.get(0)).getDirection();
    }

    private Double distance(Point a, Point b) {
        if (a == null || b == null) {
            return Double.MAX_VALUE;
        }
        return Math.pow(b.x - a.x, 2.0) + Math.pow(b.y - a.y, 2.0);
    }
}

