package snakegame.session;

/**
 * Enumerao que define o nvel de dificuldade.
 * 
 * @author Tecgraf/PUC-Rio
 */
public enum Level {

  /** Fcil. */
  EASY(150, "easy"),

  /** Normal. */
  NORMAL(100, "normal"),

  /** Difcil. */
  HARD(50, "hard");

  /** Passo em milisegundos entre os movimentos. */
  public final int step;

  /** Chave de internacionalizao. */
  public final String key;

  /**
   * Construtor.
   * 
   * @param step passo em milisegundos entre os movimentos.
   * @param key chave de internacionalizao.
   */
  private Level(int step, String key) {
    this.step = step;
    this.key = String.format("%s.%s", getClass().getSimpleName(), key);
  }
}
