package teste;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.application.IApplication;
import csdk.v2.api.application.IApplicationContext;
import csdk.v2.api.application.IMessage;
import csdk.v2.api.application.IMessageSender;
import csdk.v2.api.core.ICSDKEnvironment;
import csdk.v2.api.application.manager.IApplicationManagerContext;
import csdk.v2.helper.application.Message;

/**
 * Aplicao de teste simples.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class Teste implements IApplication {

  /**
   * A propriedade com o label que aparece.
   */
  private static final String LABEL_PROPERTY = "label";

  /**
   * Interface padro para o ambiente CSDK.
   */
  private final ICSDKEnvironment csdkInterface;

  /**
   * Contexto da aplicao.
   */
  private final IApplicationContext appContext;

  /**
   * Contexto de geriencia de aplicaes.
   */
  private final IApplicationManagerContext appManagerContext;

  /**
   * Janela principal da aplicao.
   */
  private final JFrame mainFrame;

  /**
   * Construtor padro.
   * 
   * @param csdkInterface interface padro para o ambiente CSDK.
   */
  public Teste(final ICSDKEnvironment csdkInterface) {
    this.csdkInterface = csdkInterface;
    this.appContext = csdkInterface.getContext(IApplicationContext.class);
    this.appManagerContext =
      csdkInterface.getContext(IApplicationManagerContext.class);
    this.mainFrame = new JFrame();
    this.mainFrame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
    this.mainFrame.addWindowListener(new WindowAdapter() {
      @Override
      public void windowClosing(WindowEvent e) {
        csdkInterface.finishApplication();
      }
    });
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canEndApplication() {
    String instanceId = appContext.getInstanceId();
    System.out.println("[" + instanceId + "] canEndApplication");
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object onSyncMessageReceived(IMessage message, IMessageSender sender) {
    StringBuffer buffer = new StringBuffer();
    buffer.append(message.getType());
    buffer.append(": ");
    buffer.append(message.getValue());
    buffer.append("\n from: ");
    buffer.append(sender.getApplicationInstanceId());
    buffer.append(" [");
    buffer.append(sender.getApplicationType());
    buffer.append("]");
    JOptionPane.showMessageDialog(mainFrame, buffer.toString());
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void onAsyncMessageReceived(IMessage message, IMessageSender sender) {
    // No recebe esse tipo de mensagem
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void onApplicationEnd() throws ApplicationException {
    String instanceId = appContext.getInstanceId();
    System.out.println("[" + instanceId + "] onApplicationEnd");
    mainFrame.dispose();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void onApplicationStart() throws ApplicationException {
    String instanceId = appContext.getInstanceId();
    System.out.println("[" + instanceId + "] onApplicationStart");
    initUI();
    mainFrame.pack();
    mainFrame.setVisible(true);
  }

  /**
   * Inicializa a interface da aplicao.
   */
  private void initUI() {
    String label;
    if (appContext.isPropertyNull(LABEL_PROPERTY)) {
      label = "ID";
    }
    else {
      label = appContext.getProperty(LABEL_PROPERTY);
    }
    JButton button =
      new JButton(label + " [" + appContext.getInstanceId() + "]");
    button.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent event) {
        try {
          String appId = appContext.getApplicationId();
          String instanceId = appManagerContext.runApplication(appId);
          appManagerContext.sendSyncMessage(instanceId, new Message("target",
            instanceId));
        }
        catch (ApplicationException e) {
          csdkInterface.handleException(e, mainFrame);
        }
      }
    });
    JPanel panel = new JPanel();
    panel.add(button);
    mainFrame.add(panel);
  }

}
