/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.StaticHttpHandlerBase;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.utils.ArraySet;

public class StaticHttpHandler
extends StaticHttpHandlerBase {
    private static final Logger LOGGER = Grizzly.logger(StaticHttpHandler.class);
    protected final ArraySet<File> docRoots = new ArraySet(File.class);

    public StaticHttpHandler() {
        this.addDocRoot(".");
    }

    public StaticHttpHandler(String ... docRoots) {
        if (docRoots != null) {
            for (String docRoot : docRoots) {
                this.addDocRoot(docRoot);
            }
        }
    }

    public StaticHttpHandler(Set<String> docRoots) {
        if (docRoots != null) {
            for (String docRoot : docRoots) {
                this.addDocRoot(docRoot);
            }
        }
    }

    public File getDefaultDocRoot() {
        File[] array = (File[])this.docRoots.getArray();
        return array != null && array.length > 0 ? array[0] : null;
    }

    public ArraySet<File> getDocRoots() {
        return this.docRoots;
    }

    public final File addDocRoot(String docRoot) {
        if (docRoot == null) {
            throw new NullPointerException("docRoot can't be null");
        }
        File file = new File(docRoot);
        this.addDocRoot(file);
        return file;
    }

    public final void addDocRoot(File docRoot) {
        this.docRoots.add((Object)docRoot);
    }

    public void removeDocRoot(File docRoot) {
        this.docRoots.remove((Object)docRoot);
    }

    @Override
    protected boolean handle(String uri, Request request, Response response) throws Exception {
        boolean found = false;
        File[] fileFolders = (File[])this.docRoots.getArray();
        if (fileFolders == null) {
            return false;
        }
        File resource = null;
        for (int i = 0; i < fileFolders.length; ++i) {
            File f;
            File webDir = fileFolders[i];
            resource = new File(webDir, uri);
            boolean exists = resource.exists();
            boolean isDirectory = resource.isDirectory();
            if (exists && isDirectory && (f = new File(resource, "/index.html")).exists()) {
                resource = f;
                found = true;
                break;
            }
            if (!isDirectory && exists) {
                found = true;
                break;
            }
            found = false;
        }
        if (!found) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "File not found {0}", resource);
            }
            return false;
        }
        assert (resource != null);
        if (!Method.GET.equals(request.getMethod())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "File found {0}, but HTTP method {1} is not allowed", new Object[]{resource, request.getMethod()});
            }
            response.setStatus(HttpStatus.METHOD_NOT_ALLOWED_405);
            response.setHeader(Header.Allow, "GET");
            return true;
        }
        StaticHttpHandler.pickupContentType(response, resource.getPath());
        this.addToFileCache(request, response, resource);
        StaticHttpHandler.sendFile(response, resource);
        return true;
    }
}

