/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.runner.filesystem;

import csdk.v2.runner.filesystem.FileType;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FileTypes {
    public static final String UNKNOWN = "UNKNOWN";
    public static final String DIRECTORY_TYPE = "DIRECTORY_TYPE";
    private static final Map<String, FileType> types = new HashMap<String, FileType>();

    public static FileType createFileType(String typeName) {
        if (FileTypes.hasFileType(typeName)) {
            String pattern = "Type {0} already exists!";
            String err = MessageFormat.format(pattern, typeName);
            throw new IllegalArgumentException(err);
        }
        FileType typ = new FileType(typeName);
        types.put(FileTypes.getFileTypeKey(typeName), typ);
        return typ;
    }

    public static FileType getFileType(String fileTypeName) {
        if (fileTypeName == null) {
            return null;
        }
        String typeName = fileTypeName.trim();
        if (typeName.equals(UNKNOWN)) {
            return null;
        }
        return types.get(FileTypes.getFileTypeKey(fileTypeName));
    }

    public static boolean hasFileType(String typeName) {
        return FileTypes.getFileType(typeName) != null;
    }

    public static FileType getFileTypeFromExtension(String extension) {
        if (extension == null) {
            throw new RuntimeException("Internal error: null extension not allowed");
        }
        for (FileType value : types.values()) {
            ArrayList<String> extensions = value.getExtensions();
            for (String ext : extensions) {
                if (!extension.trim().equalsIgnoreCase(ext.trim())) continue;
                return value;
            }
        }
        return null;
    }

    public static String[] getExtensionsFromFileType(String typeName) {
        if (typeName == null) {
            throw new RuntimeException("Internal error: null type name not allowed");
        }
        if (typeName.equals(UNKNOWN)) {
            return null;
        }
        FileType fileType = types.get(FileTypes.getFileTypeKey(typeName));
        if (fileType == null) {
            return null;
        }
        ArrayList<String> extensions = fileType.getExtensions();
        return extensions.toArray(new String[extensions.size()]);
    }

    private static String getFileTypeKey(String typeName) {
        return typeName.trim().toLowerCase();
    }

    public static void loadFileTypes(InputStream input) {
        FileType fileType;
        types.clear();
        Properties properties = FileTypes.loadProperties(input);
        int i = 0;
        while ((fileType = FileTypes.makeFileType(properties, i)) != null) {
            types.put(FileTypes.getFileTypeKey(fileType.getName()), fileType);
            ++i;
        }
    }

    private static FileType makeFileType(Properties properties, int id) {
        String typeCode = FileTypes.getTypeCode(id, properties);
        if (typeCode == null) {
            return null;
        }
        try {
            List<String> extensions = FileTypes.getExtensions(typeCode, properties);
            FileType fileType = new FileType(typeCode);
            if (extensions != null) {
                for (String extension : extensions) {
                    fileType.addExtension(extension);
                }
            }
            return fileType;
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading file type " + id);
        }
    }

    private static List<String> getExtensions(String typeCode, Properties properties) {
        String propName = "filetype." + typeCode + ".extensions";
        String extensions = properties.getProperty(propName);
        if (extensions == null) {
            return null;
        }
        String[] extS = extensions.split(",");
        ArrayList<String> extVector = new ArrayList<String>(extS.length);
        for (String ext : extS) {
            extVector.add(ext.trim().toLowerCase());
        }
        return extVector;
    }

    private static String getTypeCode(int i, Properties properties) {
        String propName = "filetype." + i + ".typeCode";
        String prop = properties.getProperty(propName);
        if (prop == null) {
            return null;
        }
        return prop.trim();
    }

    private static Properties loadProperties(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("Input stream cannot be null");
        }
        try {
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file types list resource", e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

