/*
 * Decompiled with CFR 0.152.
 */
package testeproj;

import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.application.IApplication;
import csdk.v2.api.application.IApplicationContext;
import csdk.v2.api.application.IMessage;
import csdk.v2.api.application.IMessageSender;
import csdk.v2.api.core.ICSDKEnvironment;
import csdk.v2.api.filesystem.FileSelectionType;
import csdk.v2.api.filesystem.IFile;
import csdk.v2.api.filesystem.IFileLock;
import csdk.v2.api.filesystem.project.IProjectContext;
import csdk.v2.api.filesystem.project.ProjectException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class TesteProj
implements IApplication {
    private final ICSDKEnvironment csdkInterface;
    private final IProjectContext projectContext;
    private final IApplicationContext appContext;
    private final Collection<IFileLock> locks;
    private final JFrame mainFrame;

    public TesteProj(final ICSDKEnvironment csdkInterface) {
        this.csdkInterface = csdkInterface;
        this.appContext = (IApplicationContext)csdkInterface.getContext(IApplicationContext.class);
        this.projectContext = (IProjectContext)csdkInterface.getContext(IProjectContext.class);
        this.locks = new ArrayList<IFileLock>();
        this.mainFrame = new JFrame();
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                csdkInterface.finishApplication();
            }
        });
    }

    public boolean canEndApplication() {
        int result = JOptionPane.showConfirmDialog(this.mainFrame, this.appContext.getString("confirm.message", new Object[0]), this.appContext.getApplicationName(), 0);
        return result == 0;
    }

    public Object onSyncMessageReceived(IMessage message, IMessageSender sender) {
        return null;
    }

    public void onAsyncMessageReceived(IMessage message, IMessageSender sender) {
    }

    public void onApplicationEnd() throws ApplicationException {
        this.mainFrame.dispose();
        for (IFileLock lock : this.locks) {
            lock.releaseLock((Window)this.mainFrame);
        }
    }

    private void initUI() {
        String openLabelName = this.appContext.getString("open.label", new Object[0]);
        final JLabel openLabel = new JLabel(openLabelName);
        String openButtonName = this.appContext.getString("open.button", new Object[0]);
        JButton openButton = new JButton(openButtonName);
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                IFile file = TesteProj.this.openFile(FileSelectionType.FILES_ONLY);
                if (file != null) {
                    try {
                        IFileLock sharedLock = file.acquireSharedLock((Window)TesteProj.this.mainFrame);
                        TesteProj.this.locks.add(sharedLock);
                        if (sharedLock.getLockStatus() == IFileLock.LockStatus.LOCK_SHARED || sharedLock.getLockStatus() == IFileLock.LockStatus.LOCK_EXCLUSIVE) {
                            openLabel.setText(file.getStringPath());
                        } else {
                            String lockMessage = TesteProj.this.appContext.getString("lock.message", new Object[0]);
                            JOptionPane.showMessageDialog(TesteProj.this.mainFrame, lockMessage);
                        }
                    }
                    catch (Exception e) {
                        TesteProj.this.csdkInterface.handleException(e, (Window)TesteProj.this.mainFrame);
                    }
                }
            }
        });
        openButton.setEnabled(this.projectContext != null);
        String openMultipleLabelName = this.appContext.getString("open.multiple.label", new Object[0]);
        final JLabel openMultipleLabel = new JLabel(openMultipleLabelName);
        String openMultipleButtonName = this.appContext.getString("open.multiple.button", new Object[0]);
        JButton openMultipleButton = new JButton(openMultipleButtonName);
        openMultipleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                IFile[] files = TesteProj.this.openMultipleFiles(FileSelectionType.FILES_ONLY);
                if (files != null) {
                    StringBuilder builder = new StringBuilder();
                    for (IFile file : files) {
                        try {
                            IFileLock sharedLock = file.acquireSharedLock((Window)TesteProj.this.mainFrame);
                            TesteProj.this.locks.add(sharedLock);
                            if (sharedLock.getLockStatus() == IFileLock.LockStatus.LOCK_SHARED || sharedLock.getLockStatus() == IFileLock.LockStatus.LOCK_EXCLUSIVE) {
                                builder.append(file.getStringPath());
                                builder.append(" ");
                            } else {
                                String lockMessage = TesteProj.this.appContext.getString("lock.message", new Object[0]);
                                JOptionPane.showMessageDialog(TesteProj.this.mainFrame, lockMessage);
                            }
                        }
                        catch (Exception e) {
                            TesteProj.this.csdkInterface.handleException(e, (Window)TesteProj.this.mainFrame);
                        }
                        openMultipleLabel.setText(builder.toString());
                    }
                }
            }
        });
        openMultipleButton.setEnabled(this.projectContext != null);
        String openDirLabelName = this.appContext.getString("open.dir.label", new Object[0]);
        final JLabel openDirLabel = new JLabel(openDirLabelName);
        String openDirButtonName = this.appContext.getString("open.dir.button", new Object[0]);
        JButton openDirButton = new JButton(openDirButtonName);
        openDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IFile file = TesteProj.this.openFile(FileSelectionType.DIRECTORIES_ONLY);
                if (file != null) {
                    openDirLabel.setText(file.getStringPath());
                }
            }
        });
        openDirButton.setEnabled(this.projectContext != null);
        String openMultipleDirLabelName = this.appContext.getString("open.multiple.dir.label", new Object[0]);
        final JLabel openMultipleDirLabel = new JLabel(openMultipleDirLabelName);
        String openMultipleDirButtonName = this.appContext.getString("open.multiple.dir.button", new Object[0]);
        JButton openMultipleDirButton = new JButton(openMultipleDirButtonName);
        openMultipleDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                IFile[] files = TesteProj.this.openMultipleFiles(FileSelectionType.DIRECTORIES_ONLY);
                if (files != null) {
                    StringBuilder builder = new StringBuilder();
                    for (IFile file : files) {
                        builder.append(file.getStringPath());
                        builder.append(" ");
                    }
                    openMultipleDirLabel.setText(builder.toString());
                }
            }
        });
        openMultipleDirButton.setEnabled(this.projectContext != null);
        String saveLabelName = this.appContext.getString("save.label", new Object[0]);
        final JLabel saveLabel = new JLabel(saveLabelName);
        String saveButtonName = this.appContext.getString("save.button", new Object[0]);
        JButton saveButton = new JButton(saveButtonName);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                IFile file = TesteProj.this.saveFile();
                if (file != null) {
                    try {
                        IFileLock sharedLock = file.acquireExclusiveLock((Window)TesteProj.this.mainFrame);
                        TesteProj.this.locks.add(sharedLock);
                        if (sharedLock.getLockStatus() == IFileLock.LockStatus.LOCK_SHARED || sharedLock.getLockStatus() == IFileLock.LockStatus.LOCK_EXCLUSIVE) {
                            saveLabel.setText(file.getStringPath());
                        } else {
                            String lockMessage = TesteProj.this.appContext.getString("lock.message", new Object[0]);
                            JOptionPane.showMessageDialog(TesteProj.this.mainFrame, lockMessage);
                        }
                    }
                    catch (Exception e) {
                        TesteProj.this.csdkInterface.handleException(e, (Window)TesteProj.this.mainFrame);
                    }
                }
            }
        });
        saveButton.setEnabled(this.projectContext != null);
        JPanel panel = new JPanel();
        panel.add(openLabel);
        panel.add(openButton);
        panel.add(openMultipleLabel);
        panel.add(openMultipleButton);
        panel.add(openDirLabel);
        panel.add(openDirButton);
        panel.add(openMultipleDirLabel);
        panel.add(openMultipleDirButton);
        panel.add(saveLabel);
        panel.add(saveButton);
        this.mainFrame.add(panel);
    }

    public void onApplicationStart() throws ApplicationException {
        this.initUI();
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
    }

    protected IFile openFile(FileSelectionType selectionType) {
        try {
            String[] fileTypes = this.appContext.getApplicationFileTypes();
            return this.projectContext.browseProjectFileInOpenMode(fileTypes, true, selectionType, (Window)this.mainFrame);
        }
        catch (ProjectException e) {
            this.csdkInterface.handleException((Exception)((Object)e), (Window)this.mainFrame);
            return null;
        }
    }

    private IFile[] openMultipleFiles(FileSelectionType selectionType) {
        try {
            String[] fileTypes = this.appContext.getApplicationFileTypes();
            return this.projectContext.browseMultipleProjectFilesInOpenMode(fileTypes, false, selectionType, (Window)this.mainFrame);
        }
        catch (ProjectException e) {
            this.csdkInterface.handleException((Exception)((Object)e), (Window)this.mainFrame);
            return null;
        }
    }

    protected IFile saveFile() {
        try {
            String[] fileTypes = this.appContext.getApplicationFileTypes();
            return this.projectContext.browseProjectFileInSaveMode(fileTypes, true, null, (Window)this.mainFrame);
        }
        catch (ProjectException e) {
            this.csdkInterface.handleException((Exception)((Object)e), (Window)this.mainFrame);
            return null;
        }
    }
}

