/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.helper.command.parameters;

import csdk.v2.helper.command.parameters.AbstractParameterValue;
import csdk.v2.helper.command.parameters.FileListValueConverter;
import csdk.v2.helper.command.parameters.FileParameterValue;
import csdk.v2.helper.command.parameters.ParameterValueConverter;
import csdk.v2.helper.command.parameters.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FileListParameterValue
extends AbstractParameterValue<List<URL>> {
    public FileListParameterValue() {
        super(new ArrayList());
    }

    public FileListParameterValue(List<FileParameterValue> values) {
        super(FileListParameterValue.convertToFileValue(values));
    }

    public FileListParameterValue(FileParameterValue[] values) {
        super(FileListParameterValue.convertToFileValue(Arrays.asList(values)));
    }

    private static List<URL> convertToFileValue(List<FileParameterValue> fileParameterValues) {
        ArrayList<URL> values = new ArrayList<URL>();
        for (FileParameterValue fileParameterValue : fileParameterValues) {
            URL value = null;
            if (fileParameterValue != null) {
                value = (URL)fileParameterValue.getValue();
            }
            values.add(value);
        }
        return values;
    }

    public void addValue(String path, String type) {
        ((List)this.getValue()).add(new URL(path, type));
    }

    public void addValue(FileParameterValue file) {
        if (file != null) {
            URL value = (URL)file.getValue();
            ((List)this.getValue()).add(new URL(value.getPath(), value.getType()));
        }
    }

    @Override
    protected ParameterValueConverter<List<URL>> getValueConverter() {
        return new FileListValueConverter();
    }
}

