/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.runner.filesystem;

import csdk.v2.api.filesystem.FileLocationType;
import csdk.v2.api.filesystem.FileLockedException;
import csdk.v2.api.filesystem.IFile;
import csdk.v2.api.filesystem.IFileLock;
import csdk.v2.runner.filesystem.CSDKLocalFileLock;
import csdk.v2.runner.filesystem.FileType;
import csdk.v2.runner.filesystem.FileTypes;
import csdk.v2.runner.filesystem.FileUtils;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;

public class RunnerFile
implements IFile {
    private File file;
    private RandomAccessFile randomFile;
    private String type;

    private static String getFileExtension(String path) {
        if (path == null) {
            String msg = "Internal error: null path not allowed.";
            throw new IllegalArgumentException(msg);
        }
        if (path.trim().equals("")) {
            String msg = "Internal error: empty path not allowed.";
            throw new IllegalArgumentException(msg);
        }
        int periodIndex = path.lastIndexOf(".");
        if (periodIndex == -1 || periodIndex == path.length() - 1) {
            return null;
        }
        return path.substring(periodIndex + 1).toLowerCase();
    }

    private File getFile() {
        return this.file;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        if (this.type == null) {
            String path = this.getAbsolutePath();
            String ext = RunnerFile.getFileExtension(path);
            if (ext == null) {
                return "UNKNOWN";
            }
            return RunnerFile.getTypeFromExtension(ext);
        }
        return this.type;
    }

    private static String getTypeFromExtension(String extension) {
        FileType fileType = FileTypes.getFileTypeFromExtension(extension);
        if (fileType == null) {
            return "UNKNOWN";
        }
        return fileType.getName();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public long position() throws IOException {
        return this.randomFile.getFilePointer();
    }

    @Override
    public void position(long newPosition) throws IOException {
        this.randomFile.seek(newPosition);
    }

    @Override
    public void close(boolean forceQuit) throws IOException {
        if (this.randomFile != null) {
            RandomAccessFile raf = this.randomFile;
            if (forceQuit) {
                this.randomFile = null;
            }
            raf.close();
            this.randomFile = null;
        }
    }

    public void close() throws IOException {
        this.close(true);
    }

    @Override
    public long size() {
        return this.file.length();
    }

    public RunnerFile(File file) {
        this.file = file;
        this.randomFile = null;
    }

    public RunnerFile(File file, String fileType) {
        this.file = file;
        this.randomFile = null;
        this.type = fileType;
    }

    @Override
    public IFile[] getChildren() {
        if (!this.file.isDirectory()) {
            return null;
        }
        ArrayList<RunnerFile> list = new ArrayList<RunnerFile>();
        for (File f : this.file.listFiles()) {
            list.add(new RunnerFile(f));
        }
        return list.toArray(new IFile[list.size()]);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    @Override
    public String[] getPath() {
        return FileUtils.splitPath(this.file.getPath());
    }

    @Override
    public String getStringPath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public void open(boolean readOnly) throws Exception {
        if (this.file.isDirectory()) {
            throw new Exception("Directory cannot be opened!");
        }
        String mode = readOnly ? "r" : "rws";
        this.randomFile = new RandomAccessFile(this.file, mode);
    }

    @Override
    public long getModificationDate() {
        return this.file.lastModified();
    }

    @Override
    public int read(byte[] dst, int off, int len, long position) throws Exception {
        this.randomFile.seek(position);
        return this.randomFile.read(dst, off, len);
    }

    @Override
    public int read(byte[] dst, long position) throws Exception {
        this.randomFile.seek(position);
        return this.randomFile.read(dst);
    }

    @Override
    public void write(byte[] src, int off, int len, long position) throws IOException, FileLockedException {
        this.randomFile.seek(position);
        this.randomFile.write(src, off, len);
    }

    @Override
    public void write(byte[] src, long position) throws IOException, FileLockedException {
        this.randomFile.seek(position);
        this.randomFile.write(src);
    }

    @Override
    public FileLocationType getFileLocationType() {
        return FileLocationType.LOCAL;
    }

    @Override
    public IFile getParent() {
        return new RunnerFile(this.file.getParentFile());
    }

    @Override
    public boolean exists() throws IOException {
        return this.file.exists();
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.file.canWrite();
    }

    @Override
    public boolean canExecute() {
        return this.file.canExecute();
    }

    @Override
    public IFileLock acquireExclusiveLock(Window window) throws Exception {
        return new CSDKLocalFileLock(this.file, false, window);
    }

    @Override
    public IFileLock acquireSharedLock(Window window) throws Exception {
        return new CSDKLocalFileLock(this.file, true, window);
    }

    @Override
    public IFile getChild(String name, Window window) throws Exception {
        if (name == null || name.trim().isEmpty()) {
            throw new Exception("Child name cannot be null");
        }
        if (this.isDirectory()) {
            File[] files = this.file.listFiles((dir, fileName) -> dir.equals(this.file) && name.equals(fileName));
            if (files != null && files.length == 1) {
                return new RunnerFile(files[0]);
            }
            return null;
        }
        throw new Exception("File is not a directory: " + this.file.getAbsolutePath());
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    @Override
    public boolean rename(String newName, Window window) throws Exception {
        return this.moveTo(this.getParent(), newName);
    }

    @Override
    public boolean move(IFile newParent, Window window) throws Exception {
        return this.moveTo(newParent, this.getName());
    }

    @Override
    public IFile copy(IFile newParent, Window window) throws Exception {
        if (newParent == null) {
            throw new Exception("Parent cannot be null");
        }
        if (this.isDirectory()) {
            throw new Exception("Cannot copy directory");
        }
        if (!newParent.getFileLocationType().equals((Object)this.getFileLocationType())) {
            throw new Exception("Parent on different file system");
        }
        if (!newParent.isDirectory()) {
            throw new Exception("Parent is not a directory: " + newParent.getStringPath());
        }
        if (!this.file.exists()) {
            throw new Exception("File does not exist: " + this.file.getPath());
        }
        Path targetDir = ((RunnerFile)newParent).getFile().toPath();
        Path targetPath = targetDir.resolve(this.file.getName());
        Path copy = Files.copy(this.file.toPath(), targetPath, new CopyOption[0]);
        return new RunnerFile(copy.toFile());
    }

    private synchronized boolean moveTo(IFile newParent, String newName) throws Exception {
        if (this.randomFile != null) {
            throw new Exception("Cannot move open file");
        }
        if (!this.file.exists()) {
            throw new Exception("File does not exist: " + this.getStringPath());
        }
        if (newParent == null) {
            throw new Exception("Parent cannot be null");
        }
        if (newName == null) {
            throw new Exception("Name cannot be null");
        }
        if (this.isDirectory()) {
            throw new Exception("Cannot move directory!");
        }
        if (!newParent.getFileLocationType().equals((Object)this.getFileLocationType())) {
            throw new Exception("Parent on different file system");
        }
        if (!newParent.isDirectory()) {
            throw new Exception("Parent is not a directory: " + newParent.getStringPath());
        }
        Path path = this.file.toPath();
        File dir = new File(newParent.getStringPath());
        Path target = dir.toPath().resolve(newName);
        try {
            Path newPath = Files.move(path, target, new CopyOption[0]);
            if (newPath != null) {
                this.file = newPath.toFile();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean delete(Window window) throws Exception {
        if (this.randomFile != null) {
            throw new Exception("Cannot delete open file");
        }
        return this.file.delete();
    }
}

