/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class DefaultLineWrapTableCellRenderer
extends JTextArea
implements TableCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public DefaultLineWrapTableCellRenderer() {
        this.setLineWrap(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int viewColumnIndex) {
        if (table != null) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
        }
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(noFocusBorder);
        }
        if (table != null) {
            this.setFont(table.getFont());
        }
        String text = value == null ? null : value.toString();
        this.adjustHeight(text);
        this.setText(text);
        return this;
    }

    protected void adjustHeight(String text) {
        if (text == null) {
            this.setRows(1);
            return;
        }
        String[] lines = text.split("\n");
        this.setRows(lines.length);
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container table = this.getParent();
        if (table != null) {
            table = table.getParent();
        }
        boolean colorMatch = back != null && table != null && back.equals(table.getBackground()) && table.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName.equals("document")) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void repaint() {
    }
}

