package textviewer.actions;

import java.awt.Window;

import javax.swing.Action;
import javax.swing.ImageIcon;

import textviewer.TextViewer;
import textviewer.actions.core.OpenAction;
import csdk.v1_0.api.filesystem.FileSelectionType;
import csdk.v1_0.api.filesystem.IFile;

/**
 * Ao de abertura do arquivo
 * 
 * @author Tecgraf/PUC-Rio
 */
public class OpenProjectAction extends OpenAction {

  /**
   * {@inheritDoc}
   */
  @Override
  protected IFile selectFile() throws Exception {
    TextViewer textViewer = getApplication();
    String[] fileTypes = new String[] { "TEXT" };
    Window frm = textViewer.getApplicationFrame();

    IFile file =
      textViewer.browseProjectFileInOpenMode(fileTypes, false,
        FileSelectionType.FILES_ONLY, frm);
    if (file == null) {
      return null;
    }
    return file;
  }

  /**
   * Construtor
   * 
   * @param textViewer a aplicao.
   */
  public OpenProjectAction(TextViewer textViewer) {
    super(textViewer);
    putValue(Action.NAME, textViewer.getString("open.project.item"));
    ImageIcon imageIcon =
      textViewer.getImageIcon(new String[] { "actions", "Open16.gif" });
    putValue(Action.SMALL_ICON, imageIcon);
  }
}
