package textviewer.actions;

import java.awt.Window;

import javax.swing.Action;

import textviewer.TextViewer;
import textviewer.actions.core.SaveAsAction;
import csdk.v1_0.api.filesystem.IFile;
import csdk.v1_0.helper.application.ApplicationImages;

/**
 * Ao de abertura do arquivo
 * 
 * @author Tecgraf/PUC-Rio
 */
public class SaveAsLocalAction extends SaveAsAction {

  /**
   * {@inheritDoc}
   */
  @Override
  protected IFile selectFile() throws Exception {
    TextViewer textViewer = getApplication();
    String[] fileTypes = new String[] { "TEXT" };
    Window frm = textViewer.getApplicationFrame();
    IFile file =
      textViewer.browseLocalFileInSaveMode(fileTypes, false, null, null, frm);
    if (file == null) {
      return null;
    }
    return file;
  }

  /**
   * Construtor
   * 
   * @param textViewer a aplicao
   */
  public SaveAsLocalAction(TextViewer textViewer) {
    super(textViewer);
    putValue(Action.NAME, textViewer.getString("save.as.local.item"));
    putValue(Action.SMALL_ICON, ApplicationImages.ICON_SAVEAS_LOCAL_16);
  }
}
