package textviewer.actions;

import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import textviewer.TextViewer;
import csdk.v1_0.api.application.ApplicationException;
import csdk.v1_0.helper.application.AbstractApplicationAction;
import csdk.v1_0.helper.application.Message;

/**
 * Ao de abertura do arquivo
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CloneAction extends AbstractApplicationAction<TextViewer> {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent ae) {
    TextViewer textViewer = getApplication();
    Message message =
      new Message(TextViewer.TEXT_MESSAGE_TYPE, textViewer.getText());
    try {
      String id = textViewer.runApplication(textViewer.getApplicationId());
      if (id != null) {
        textViewer.sendMessage(id, message);
      }
    }
    catch (ApplicationException e) {
      JOptionPane.showMessageDialog(textViewer.getApplicationFrame(),
        textViewer.getString("clone.error"), textViewer.getApplicationName(),
        JOptionPane.ERROR_MESSAGE);
    }
  }

  /**
   * Construtor
   * 
   * @param textViewer a aplicao.
   */
  public CloneAction(TextViewer textViewer) {
    super(textViewer);
    putValue(Action.NAME, textViewer.getString("clone.item"));
    ImageIcon icon = textViewer.getSmallApplicationIcon();
    putValue(Action.SMALL_ICON, icon);
  }
}
