package textviewer.actions;

import java.awt.event.ActionEvent;
import java.io.InputStream;

import javax.swing.Action;
import javax.swing.ImageIcon;

import textviewer.TextViewer;
import csdk.v1_0.helper.application.AbstractApplicationAction;

/**
 * Ao de abertura do arquivo de informaes.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class InfoAction extends AbstractApplicationAction<TextViewer> {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent ae) {
    TextViewer textViewer = getApplication();
    @SuppressWarnings("resource")
    InputStream stream =
      textViewer.getResourceAsStream(new String[] { "help", "info.txt" });
    textViewer.openStream(stream, textViewer.getCharset());
  }

  /**
   * Construtor
   * 
   * @param textViewer a aplicao.
   */
  public InfoAction(TextViewer textViewer) {
    super(textViewer);
    putValue(Action.NAME, textViewer.getString("info.item"));
    ImageIcon icon = textViewer.getSmallApplicationIcon();
    putValue(Action.SMALL_ICON, icon);
  }
}
