/*
 * Decompiled with CFR 0.152.
 */
package textviewer;

import csdk.v1_0.api.application.IMessage;
import csdk.v1_0.api.application.IMessageSender;
import csdk.v1_0.api.core.ICSDKEnvironment;
import csdk.v1_0.api.filesystem.IFile;
import csdk.v1_0.api.filesystem.project.IProjectObserver;
import csdk.v1_0.helper.AbstractCSDKWindowApplication;
import csdk.v1_0.helper.application.AbstractApplication;
import csdk.v1_0.helper.application.ApplicationAboutAction;
import csdk.v1_0.helper.application.ApplicationExitAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.gui.Task;
import textviewer.actions.CloneAction;
import textviewer.actions.HelpAction;
import textviewer.actions.InfoAction;
import textviewer.actions.OpenLocalAction;
import textviewer.actions.OpenProjectAction;
import textviewer.actions.SaveAction;
import textviewer.actions.SaveAsLocalAction;
import textviewer.actions.SaveAsProjectAction;

public class TextViewer
extends AbstractCSDKWindowApplication {
    public static final String TEXT_MESSAGE_TYPE = "text";
    private static final Object FILE_MESSAGE_TYPE = "file";
    private final JTextArea textArea = new JTextArea();
    private IFile selectedFile = null;
    private final OpenProjectAction openProjectAction = new OpenProjectAction(this);
    private final SaveAsProjectAction saveAsProjectAction = new SaveAsProjectAction(this);

    public TextViewer(ICSDKEnvironment csdkInterface) {
        super(csdkInterface);
    }

    private JMenu buildAboutMenu() {
        JMenu menu = new JMenu(this.getString("about.menu", new Object[0]));
        menu.add((Action)((Object)new InfoAction(this)));
        menu.addSeparator();
        menu.add((Action)((Object)new HelpAction(this)));
        menu.addSeparator();
        menu.add((Action)new ApplicationAboutAction((AbstractApplication)this, (Window)this.getApplicationFrame()));
        return menu;
    }

    protected void applicationStarted(JFrame mainFrame) {
        boolean enableProjectActions;
        boolean bl = enableProjectActions = this.isProjectContextAvailable() && this.getCurrentProjectId() != null;
        if (enableProjectActions) {
            IProjectObserver listener = new IProjectObserver(){

                public void onProjectOpen(String projectId) {
                    TextViewer.this.setProjectActionsEnabled(true);
                }

                public void onProjectClose(String projectId) {
                    TextViewer.this.setProjectActionsEnabled(false);
                }
            };
            this.addProjectObserver(listener);
        }
        this.setProjectActionsEnabled(enableProjectActions);
        JMenuBar menuBar = this.buildMenuBar();
        mainFrame.setJMenuBar(menuBar);
        JPanel panel = new JPanel();
        this.textArea.setFont(new Font("Monospaced", 1, 14));
        this.textArea.setTabSize(4);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setVerticalScrollBarPolicy(22);
        Dimension scrDim = new Dimension(600, 400);
        scrollPane.setSize(scrDim);
        scrollPane.setPreferredSize(scrDim);
        scrollPane.setMinimumSize(scrDim);
        panel.setLayout(new BorderLayout());
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)this.buildToolbar(), "North");
        mainFrame.getContentPane().add(panel);
        mainFrame.setSize(new Dimension(600, 400));
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.buildOptionsMenu());
        menuBar.add(this.buildAboutMenu());
        return menuBar;
    }

    private JMenu buildOptionsMenu() {
        JMenu menu = new JMenu(this.getString("options.menu", new Object[0]));
        menu.add((Action)((Object)this.openProjectAction));
        menu.add((Action)((Object)new OpenLocalAction(this)));
        menu.addSeparator();
        menu.add((Action)((Object)this.saveAsProjectAction));
        menu.add((Action)((Object)new SaveAsLocalAction(this)));
        menu.add((Action)((Object)new SaveAction(this)));
        menu.addSeparator();
        menu.add((Action)((Object)new CloneAction(this)));
        menu.addSeparator();
        menu.add((Action)new ApplicationExitAction((AbstractApplication)this));
        return menu;
    }

    private JToolBar buildToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.add((Action)((Object)this.openProjectAction));
        toolbar.add((Action)((Object)this.saveAsProjectAction));
        toolbar.setFloatable(false);
        return toolbar;
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String string) {
        this.textArea.setText(string);
        this.textArea.setCaretPosition(0);
    }

    public boolean canEndApplication() {
        if (this.selectedFile == null) {
            return true;
        }
        int result = JOptionPane.showConfirmDialog(this.getApplicationFrame(), this.getString("confirm.message", new Object[0]), this.getApplicationName(), 0);
        return result == 0;
    }

    public IFile getSelectedFile() {
        return this.selectedFile;
    }

    public void setSelectedFile(IFile selectedFile) {
        this.closeFile(selectedFile);
        this.selectedFile = selectedFile;
    }

    public void onMessageReceived(IMessage message, IMessageSender sender) {
        String type = message.getType();
        if (type.equals(TEXT_MESSAGE_TYPE)) {
            this.setText((String)message.getValue());
        }
        if (type.equals(FILE_MESSAGE_TYPE)) {
            IFile value = (IFile)message.getValue();
            this.openFile(value);
        }
    }

    public void saveFile(final IFile file) {
        this.setSelectedFile(file);
        Task<Void> task = new Task<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void performTask() throws Exception {
                OutputStreamWriter writer = null;
                try {
                    String content = TextViewer.this.getText();
                    OutputStream stream = file.getOutputStream();
                    Charset charset = TextViewer.this.getCharset(file);
                    writer = new OutputStreamWriter(stream, charset);
                    writer.write(content);
                    writer.flush();
                }
                catch (Throwable throwable) {
                    FileUtils.close(writer);
                    throw throwable;
                }
                FileUtils.close((Closeable)writer);
            }

            protected void afterTaskUI() {
                String key = "save.ok.message";
                String msg = TextViewer.this.getString(key, new Object[0]);
                JOptionPane.showMessageDialog(TextViewer.this.getApplicationFrame(), msg, TextViewer.this.getApplicationName(), 1);
            }
        };
        task.setProgressDialogDelay(0);
        task.execute((Window)this.getApplicationFrame(), this.getApplicationName(), this.getString("open.task", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(IFile file) {
        try {
            if (file != null) {
                this.openStream(file.getInputStream(), this.getCharset(file));
            }
        }
        catch (IOException e) {
            this.handleException(e, this.getApplicationFrame());
        }
        finally {
            this.setSelectedFile(file);
            this.closeFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openStream(final InputStream stream, final Charset charset) {
        if (stream != null) {
            try {
                Task<String> task = new Task<String>(){
                    InputStreamReader reader = null;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void performTask() throws Exception {
                        StringBuffer stringBuffer = new StringBuffer();
                        try {
                            InputStream in = stream;
                            this.reader = new InputStreamReader(in, charset);
                            int BUFFER_SIZE = 128;
                            char[] buffer = new char[BUFFER_SIZE];
                            int nbytes = this.reader.read(buffer);
                            while (nbytes > 0) {
                                stringBuffer.append(buffer, 0, nbytes);
                                nbytes = this.reader.read(buffer);
                            }
                            this.setResult(stringBuffer.toString());
                        }
                        finally {
                            FileUtils.close((Closeable)this.reader);
                        }
                    }

                    protected void afterTaskUI() {
                        String text = (String)this.getResult();
                        TextViewer.this.setText(text);
                    }
                };
                task.setProgressDialogDelay(0);
                task.execute((Window)this.getApplicationFrame(), this.getApplicationName(), this.getString("open.task", new Object[0]));
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    this.handleException(e, this.getApplicationFrame());
                }
            }
        }
    }

    private void setProjectActionsEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextViewer.this.openProjectAction.setEnabled(enabled);
                TextViewer.this.saveAsProjectAction.setEnabled(enabled);
            }
        });
    }

    private void closeFile(IFile file) {
        try {
            if (file != null) {
                file.close(true);
            }
        }
        catch (IOException e) {
            this.handleException(e, this.getApplicationFrame());
        }
    }

    protected void applicationEnded() {
        this.closeFile(this.selectedFile);
    }
}

