/*
 * Decompiled with CFR 0.152.
 */
package user;

import csdk.v1_0.api.application.ApplicationException;
import csdk.v1_0.api.core.ICSDKEnvironment;
import csdk.v1_0.api.user.IUser;
import csdk.v1_0.api.user.IUserContext;
import csdk.v1_0.api.user.UserException;
import csdk.v1_0.helper.AbstractCSDKWindowApplication;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class UserApplication
extends AbstractCSDKWindowApplication {
    private IUserContext userContext;

    public UserApplication(ICSDKEnvironment env) {
        super(env);
        this.userContext = (IUserContext)env.getContext(IUserContext.class);
    }

    protected void applicationStarted(JFrame frame) throws ApplicationException {
        if (this.userContext != null && this.userContext.isActive()) {
            String currentUserLabel = this.getString("current.user.button", new Object[0]);
            JButton currentUser = new JButton(currentUserLabel);
            currentUser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserApplication.this.showCurrentUser();
                }
            });
            String userByLoginLabel = this.getString("user.by.login.button", new Object[0]);
            JButton userByLogin = new JButton(userByLoginLabel);
            userByLogin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserApplication.this.showUserByLogin();
                }
            });
            String allUsersLabel = this.getString("all.users.button", new Object[0]);
            JButton allUsers = new JButton(allUsersLabel);
            allUsers.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserApplication.this.showAllUsers();
                }
            });
            frame.setLayout(new FlowLayout());
            frame.add(currentUser);
            frame.add(userByLogin);
            frame.add(allUsers);
            frame.pack();
        } else {
            String message = this.getString("error.message", new Object[0]);
            JOptionPane.showMessageDialog(this.getApplicationFrame(), message);
        }
    }

    private void showAllUsers() {
        try {
            IUser[] users = this.userContext.getAllUsers((Window)this.getApplicationFrame());
            StringBuffer buffer = new StringBuffer();
            for (IUser user : users) {
                String description = this.createUserDescription(user);
                buffer.append(description + "\n");
            }
            String message = buffer.toString();
            JOptionPane.showMessageDialog(this.getApplicationFrame(), message);
        }
        catch (UserException e) {
            this.handleException((Exception)((Object)e), this.getApplicationFrame());
        }
    }

    private void showUserByLogin() {
        try {
            String login = JOptionPane.showInputDialog(this.getApplicationFrame(), (Object)"login:");
            if (login != null && !login.isEmpty()) {
                IUser user = this.userContext.getUserByLogin(login, (Window)this.getApplicationFrame());
                String message = this.createUserDescription(user);
                JOptionPane.showMessageDialog(this.getApplicationFrame(), message);
            }
        }
        catch (UserException e) {
            this.handleException((Exception)((Object)e), this.getApplicationFrame());
        }
    }

    private void showCurrentUser() {
        try {
            IUser user = this.userContext.getCurrentUser();
            String message = this.createUserDescription(user);
            JOptionPane.showMessageDialog(this.getApplicationFrame(), message);
        }
        catch (UserException e) {
            this.handleException((Exception)((Object)e), this.getApplicationFrame());
        }
    }

    private String createUserDescription(IUser user) {
        StringBuffer buffer = new StringBuffer();
        String name = user.getName();
        String login = user.getLogin();
        String[] emails = user.getEmails();
        boolean admin = user.isAdmin();
        buffer.append("login: ");
        buffer.append(login);
        if (admin) {
            buffer.append("*");
        }
        buffer.append("\n");
        buffer.append("name: ");
        buffer.append(name);
        buffer.append("\n");
        if (emails.length > 0) {
            buffer.append("emails: ");
            buffer.append("\n");
            for (String email : emails) {
                buffer.append(email);
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    protected void applicationEnded() throws ApplicationException {
    }
}

