package csdk.v1_0.runner.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import csdk.v1_0.api.core.IContext;
import csdk.v1_0.api.user.IUser;
import csdk.v1_0.api.user.IUserContext;
import csdk.v1_0.api.user.UserException;
import csdk.v1_0.runner.ApplicationRegistry;
import csdk.v1_0.runner.CSDKLogger;
import csdk.v1_0.runner.application.DefaultContextFactory;
import csdk.v1_0.runner.user.RunnerUser;
import csdk.v1_0.runner.user.RunnerUserContext;

/**
 * Fbrica de contextos que inclui um contexto de usurios populados
 * artificialmente.
 */
public class UserContextFactory extends DefaultContextFactory {

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<Class<? extends IContext>, IContext> createCSDKContexts(
    String instanceId, ApplicationRegistry registry, Properties properties) {
    Map<Class<? extends IContext>, IContext> contexts =
      super.createCSDKContexts(instanceId, registry, properties);
    RunnerUserContext createUserContext;
    try {
      createUserContext = createUserContext();
      contexts.put(IUserContext.class, createUserContext);
    }
    catch (UserException e) {
      CSDKLogger logger = CSDKLogger.getInstance();
      logger.logSevere("Error creating User Context!");
    }
    return contexts;
  }

  /**
   * Cria o contexto de usurios.
   * 
   * @return o contexto de usurios.
   * @throws UserException em caso de erro ao criar os usurios.
   */
  protected RunnerUserContext createUserContext() throws UserException {
    Map<String, IUser> users = new HashMap<String, IUser>();
    String currentUserName = System.getProperty("user.name");
    IUser currentUser =
      new RunnerUser(currentUserName, currentUserName, null, false);
    String adminUserName = "admin";
    String[] adminMail = new String[] { "admin@admin.com" };
    IUser adminUser =
      new RunnerUser(adminUserName, adminUserName, adminMail, true);
    users.put(currentUserName, currentUser);
    users.put(adminUserName, adminUser);
    return new RunnerUserContext(users, currentUserName);
  }
}
