/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner.core;

import csdk.v1_0.api.core.IContext;
import csdk.v1_0.api.user.IUser;
import csdk.v1_0.api.user.IUserContext;
import csdk.v1_0.api.user.UserException;
import csdk.v1_0.runner.ApplicationRegistry;
import csdk.v1_0.runner.CSDKLogger;
import csdk.v1_0.runner.application.DefaultContextFactory;
import csdk.v1_0.runner.user.RunnerUser;
import csdk.v1_0.runner.user.RunnerUserContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class UserContextFactory
extends DefaultContextFactory {
    public Map<Class<? extends IContext>, IContext> createCSDKContexts(String instanceId, ApplicationRegistry registry, Properties properties) {
        Map contexts = super.createCSDKContexts(instanceId, registry, properties);
        try {
            RunnerUserContext createUserContext = this.createUserContext();
            contexts.put(IUserContext.class, createUserContext);
        }
        catch (UserException e) {
            CSDKLogger logger = CSDKLogger.getInstance();
            logger.logSevere("Error creating User Context!");
        }
        return contexts;
    }

    protected RunnerUserContext createUserContext() throws UserException {
        HashMap<String, IUser> users = new HashMap<String, IUser>();
        String currentUserName = System.getProperty("user.name");
        RunnerUser currentUser = new RunnerUser(currentUserName, currentUserName, null, false);
        String adminUserName = "admin";
        String[] adminMail = new String[]{"admin@admin.com"};
        RunnerUser adminUser = new RunnerUser(adminUserName, adminUserName, adminMail, true);
        users.put(currentUserName, currentUser);
        users.put(adminUserName, adminUser);
        return new RunnerUserContext(users, currentUserName);
    }
}

