/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_2.common.logic;

import java.util.HashMap;
import java.util.Map;

public enum Operation {
    OPEN_READ_ONLY(0),
    OPEN_READ_WRITE(1),
    CLOSE(2),
    SET_SIZE(3),
    GET_POSITION(4),
    SET_POSITION(5),
    GET_SIZE(6),
    READ(7),
    WRITE(8),
    KEEP_ALIVE(9);

    private byte code;
    private static final Map<Byte, Operation> codesMap;

    private Operation(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    public static Operation valueOf(byte code) {
        return codesMap.get(code);
    }

    static {
        codesMap = new HashMap<Byte, Operation>();
        for (Operation operation : Operation.values()) {
            codesMap.put(operation.code, operation);
        }
    }
}

