/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_2.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import tecgraf.ftc_1_2.server.ChannelClosedReason;
import tecgraf.ftc_1_2.server.FileChannelRequestInfo;
import tecgraf.ftc_1_2.server.FileServer;
import tecgraf.ftc_1_2.server.states.State;
import tecgraf.ftc_1_2.server.states.VersionHandshakeState;

public final class Session {
    private SocketChannel channel = null;
    private ByteBuffer buffer = null;
    private FileServer fileServer = null;
    private State currentState = null;
    private FileChannelRequestInfo fileChannelInfo = null;
    private FileChannel fileChannel = null;
    private boolean readOnly = true;
    private long lastActivity = 0L;

    Session(SocketChannel channel, FileServer fileServer) {
        this.channel = channel;
        this.buffer = ByteBuffer.allocateDirect(fileServer.getConfig().getClientBufferSize());
        this.fileServer = fileServer;
        this.currentState = new VersionHandshakeState();
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public FileServer getFileServer() {
        return this.fileServer;
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(State state) {
        this.currentState = state;
    }

    public FileChannelRequestInfo getFileChannelInfo() {
        return this.fileChannelInfo;
    }

    public void setFileChannelInfo(FileChannelRequestInfo fileChannelInfo) {
        this.fileChannelInfo = fileChannelInfo;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public void setFileChannel(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void close(ChannelClosedReason reason) {
        this.closeFileChannel(reason);
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.currentState = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeFileChannel(ChannelClosedReason reason) {
        if (this.fileChannel == null) {
            return false;
        }
        try {
            this.fileChannel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.fileChannel = null;
            this.fileServer.getFileProvider().fileChannelClosed(this.fileChannelInfo.getRequester(), this.fileChannelInfo.getFileId(), reason);
        }
        return true;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public void markLastActivity() {
        this.lastActivity = System.currentTimeMillis();
    }
}

