/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_2.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_2.common.logic.Operation;
import tecgraf.ftc_1_2.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_2.server.Session;
import tecgraf.ftc_1_2.server.states.CloseState;
import tecgraf.ftc_1_2.server.states.GetPositionState;
import tecgraf.ftc_1_2.server.states.GetSizeState;
import tecgraf.ftc_1_2.server.states.OpenReadOnlyState;
import tecgraf.ftc_1_2.server.states.OpenReadWriteState;
import tecgraf.ftc_1_2.server.states.ReadState;
import tecgraf.ftc_1_2.server.states.SetPositionState;
import tecgraf.ftc_1_2.server.states.SetSizeState;
import tecgraf.ftc_1_2.server.states.State;
import tecgraf.ftc_1_2.server.states.WriteState;

public final class GetOperationState
implements State {
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    public GetOperationState() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado de ler opera\u00e7\u00f5es.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean read(Session session) {
        byte operationCode;
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        buffer.limit(PrimitiveTypeSize.BYTE.getSize());
        try {
            if (channel.read(buffer) > 0) {
                session.markLastActivity();
            }
            if (buffer.hasRemaining()) {
                boolean bl = true;
                return bl;
            }
            buffer.flip();
            operationCode = buffer.get();
        }
        catch (IOException e) {
            session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
            boolean bl = false;
            return bl;
        }
        finally {
            buffer.clear();
        }
        Operation operation = Operation.valueOf(operationCode);
        if (operation == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Opera\u00e7\u00e3o desconhecida " + operationCode);
            }
        } else {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Opera\u00e7\u00e3o obtida " + (Object)((Object)operation));
            }
            session.setCurrentState(this.getState(operation));
        }
        return true;
    }

    private State getState(Operation operation) {
        switch (operation) {
            case OPEN_READ_ONLY: {
                return new OpenReadOnlyState();
            }
            case OPEN_READ_WRITE: {
                return new OpenReadWriteState();
            }
            case CLOSE: {
                return new CloseState();
            }
            case SET_SIZE: {
                return new SetSizeState();
            }
            case GET_POSITION: {
                return new GetPositionState();
            }
            case SET_POSITION: {
                return new SetPositionState();
            }
            case GET_SIZE: {
                return new GetSizeState();
            }
            case READ: {
                return new ReadState();
            }
            case WRITE: {
                return new WriteState();
            }
        }
        return null;
    }

    @Override
    public boolean write(Session session) {
        return true;
    }
}

