/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_2.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_2.common.logic.ErrorCode;
import tecgraf.ftc_1_2.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_2.server.Session;
import tecgraf.ftc_1_2.server.states.GetOperationState;
import tecgraf.ftc_1_2.server.states.State;

public class KeepAliveState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");

    public KeepAliveState() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado de obten\u00e7\u00e3o do tamanho do arquivo.");
        }
    }

    @Override
    public boolean read(Session session) {
        return true;
    }

    @Override
    public boolean write(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(ErrorCode.OK.getCode());
                buffer.flip();
                this.currentState = InternalState.RETURN_MSG_WRITTEN;
            }
            case RETURN_MSG_WRITTEN: {
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Erro ao escrever no canal.");
                    }
                    return false;
                }
                buffer.clear();
                session.setCurrentState(new GetOperationState());
                if (!logger.isLoggable(Level.FINER)) break;
                logger.finer("C\u00f3digo OK enviado.");
            }
        }
        return true;
    }

    private static enum InternalState {
        INITIAL,
        RETURN_MSG_WRITTEN;

    }
}

