/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class Parameter {
    private String id = null;
    private String label = null;
    private TypeEnum type = null;
    private String description = null;
    private Boolean optional = null;
    private Boolean hidden = null;
    private Boolean ignoreIfHidden = null;
    private Boolean ignoreIfDisabled = null;
    private Object defaultValue = null;

    public Parameter id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The identification of the parameter.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Parameter label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(value="The label of the parameter.")
    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Parameter type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Parameter description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The parameter description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Parameter optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @ApiModelProperty(value="If the paramenter is not mandatory.")
    @JsonProperty(value="optional")
    public Boolean getOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public Parameter hidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @ApiModelProperty(value="If the paramenter is hidden.")
    @JsonProperty(value="hidden")
    public Boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Parameter ignoreIfHidden(Boolean ignoreIfHidden) {
        this.ignoreIfHidden = ignoreIfHidden;
        return this;
    }

    @ApiModelProperty(value="If the parameter is hidden, it must not be used as parameter for the algorithm execution.")
    @JsonProperty(value="ignore_if_hidden")
    public Boolean getIgnoreIfHidden() {
        return this.ignoreIfHidden;
    }

    public void setIgnoreIfHidden(Boolean ignoreIfHidden) {
        this.ignoreIfHidden = ignoreIfHidden;
    }

    public Parameter ignoreIfDisabled(Boolean ignoreIfDisabled) {
        this.ignoreIfDisabled = ignoreIfDisabled;
        return this;
    }

    @ApiModelProperty(value="If the parameter is disabled, it must not be used as parameter for the algorithm execution.")
    @JsonProperty(value="ignore_if_disabled")
    public Boolean getIgnoreIfDisabled() {
        return this.ignoreIfDisabled;
    }

    public void setIgnoreIfDisabled(Boolean ignoreIfDisabled) {
        this.ignoreIfDisabled = ignoreIfDisabled;
    }

    public Parameter defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @ApiModelProperty(value="A json object that is the default value for this parameter. It depends of the parameter type.")
    @JsonProperty(value="default_value")
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        return Objects.equals(this.id, parameter.id) && Objects.equals(this.label, parameter.label) && Objects.equals((Object)this.type, (Object)parameter.type) && Objects.equals(this.description, parameter.description) && Objects.equals(this.optional, parameter.optional) && Objects.equals(this.hidden, parameter.hidden) && Objects.equals(this.ignoreIfHidden, parameter.ignoreIfHidden) && Objects.equals(this.ignoreIfDisabled, parameter.ignoreIfDisabled) && Objects.equals(this.defaultValue, parameter.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.label, this.type, this.description, this.optional, this.hidden, this.ignoreIfHidden, this.ignoreIfDisabled, this.defaultValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Parameter {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("    hidden: ").append(this.toIndentedString(this.hidden)).append("\n");
        sb.append("    ignoreIfHidden: ").append(this.toIndentedString(this.ignoreIfHidden)).append("\n");
        sb.append("    ignoreIfDisabled: ").append(this.toIndentedString(this.ignoreIfDisabled)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        INTEGER("integer"),
        DOUBLE("double"),
        BOOLEAN("boolean"),
        STRING("string"),
        ENUMERATION("enumeration"),
        INPUT_FILE("input_file"),
        OUTPUT_FILE("output_file"),
        LOG_FILE("log_file"),
        UNSUPPORTED("unsupported");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

