/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.adapter.algorithm.v1;

import csbase.logic.AlgorithmExecutionPermission;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.remote.AlgorithmServiceInterface;
import csbase.remote.ClientRemoteLocator;
import ibase.common.ServiceAdapter;
import ibase.exception.InternalServiceException;
import ibase.rest.adapter.algorithm.v1.ParameterMapper;
import ibase.rest.adapter.algorithm.v1.RequirementsBuilder;
import ibase.rest.api.algorithm.v1.adapter.AlgorithmNotFoundException;
import ibase.rest.api.algorithm.v1.adapter.AlgorithmServiceAdapter;
import ibase.rest.api.algorithm.v1.adapter.VersionNotFoundException;
import ibase.rest.model.algorithm.v1.Algorithm;
import ibase.rest.model.algorithm.v1.AlgorithmConfiguration;
import ibase.rest.model.algorithm.v1.AlgorithmVersion;
import ibase.rest.model.algorithm.v1.User;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class CSBaseAlgorithmServiceAdapter
implements AlgorithmServiceAdapter {
    private static final String CURRENT_SYSTEM_ID = ".";
    private ParameterMapper mapper = new ParameterMapper();

    public void setLocale(Locale locale) {
        ClientRemoteLocator.administrationService.setLocale(locale);
    }

    public boolean existsAlgorithm(String algorithmId) {
        AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        return this.getAlgorithmInfo(service, algorithmId) != null;
    }

    public boolean existsAlgorithmVersion(String algorithmId, String versionId) throws AlgorithmNotFoundException {
        AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        try {
            AlgorithmInfo algoInfo = this.getAlgorithmInfo(service, algorithmId);
            if (algoInfo == null) {
                throw new AlgorithmNotFoundException();
            }
            AlgorithmVersionId algoVersionId = AlgorithmVersionId.create((String)versionId);
            AlgorithmVersionInfo version = algoInfo.getVersionInfo((Object)algoVersionId);
            return version != null;
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public List<Algorithm> getAlgorithms(Predicate<Algorithm> predicate) {
        AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        try {
            AlgorithmInfo[] algoInfos = service.getAllInfo();
            ArrayList<Algorithm> algorithms = new ArrayList<Algorithm>();
            csbase.logic.User user = csbase.logic.User.getUserByLogin((String)ServiceAdapter.getCurrenUser());
            Arrays.asList(algoInfos).forEach(i -> {
                if (this.userHasPermissionToExecuteAlgorithm(user, i.getName())) {
                    Algorithm a = this.buildAlgorithm((AlgorithmInfo)i);
                    if (predicate == null) {
                        algorithms.add(a);
                    } else if (predicate.test(a)) {
                        algorithms.add(a);
                    }
                }
            });
            return algorithms;
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public Optional<Algorithm> getAlgorithm(String algorithmId) {
        AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        try {
            Optional<Algorithm> algorithm = Optional.empty();
            AlgorithmInfo algoInfo = this.getAlgorithmInfo(service, algorithmId);
            if (algoInfo != null) {
                algorithm = Optional.of(this.buildAlgorithm(algoInfo));
            }
            return algorithm;
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public List<AlgorithmVersion> getAlgorithmVersions(String algorithmId) throws AlgorithmNotFoundException {
        System.out.println("getAlgorithmVersions: " + algorithmId);
        AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        try {
            AlgorithmInfo algoInfo = this.getAlgorithmInfo(service, algorithmId);
            if (algoInfo == null) {
                throw new AlgorithmNotFoundException();
            }
            Vector versionInfos = algoInfo.getVersions();
            if (versionInfos != null) {
                List<AlgorithmVersion> versions = versionInfos.stream().map(v -> this.buildAlgorithmVersion(algoInfo, (AlgorithmVersionInfo)v)).collect(Collectors.toList());
                return versions;
            }
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        return null;
    }

    public Optional<AlgorithmVersion> getAlgorithmVersion(String algorithmId, String versionId) throws AlgorithmNotFoundException {
        System.out.println("getAlgorithmVersion: " + algorithmId + " - " + versionId);
        AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        AlgorithmVersionId algoVersionId = AlgorithmVersionId.create((String)versionId);
        try {
            AlgorithmInfo algoInfo = this.getAlgorithmInfo(service, algorithmId);
            if (algoInfo == null) {
                throw new AlgorithmNotFoundException();
            }
            Optional<AlgorithmVersion> algorithmVersion = Optional.empty();
            AlgorithmVersionInfo version = algoInfo.getVersionInfo((Object)algoVersionId);
            if (version != null) {
                algorithmVersion = Optional.of(this.buildAlgorithmVersion(algoInfo, version));
            }
            return algorithmVersion;
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    public AlgorithmConfiguration getAlgorithmConfiguration(String algorithmId, String versionId) throws AlgorithmNotFoundException, VersionNotFoundException {
        System.out.println("getAlgorithmConfiguration: " + algorithmId + " - " + versionId);
        if (!this.existsAlgorithm(algorithmId)) {
            throw new AlgorithmNotFoundException();
        }
        if (!this.existsAlgorithmVersion(algorithmId, versionId)) {
            throw new VersionNotFoundException();
        }
        AlgorithmConfiguration algorithmConfig = new AlgorithmConfiguration();
        AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        AlgorithmVersionId algoVersionId = AlgorithmVersionId.create((String)versionId);
        try {
            AlgorithmConfigurator configurator = service.createAlgorithmConfigurator(algorithmId, algoVersionId);
            if (SimpleAlgorithmConfigurator.class.isInstance(configurator)) {
                SimpleAlgorithmConfigurator simpleConfigurator = (SimpleAlgorithmConfigurator)SimpleAlgorithmConfigurator.class.cast(configurator);
                List groups = simpleConfigurator.getGroups();
                algorithmConfig.setGroups(groups.stream().map(g -> this.buildParameterGroup((ParameterGroup)g)).collect(Collectors.toList()));
                algorithmConfig.setCommand(simpleConfigurator.getCommandBinaryName());
                algorithmConfig.setExecutionType(this.getExecutionType(simpleConfigurator.getExecutionType()));
            }
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        return algorithmConfig;
    }

    private Algorithm buildAlgorithm(AlgorithmInfo info) {
        Vector versions;
        Algorithm algorithm = new Algorithm();
        algorithm.setName(info.getName());
        algorithm.setId(info.getId());
        algorithm.setDescription(info.getDescription());
        String owner = info.getOwner();
        if (owner != null) {
            algorithm.setWhoCreated(this.buildRestUser(owner));
        }
        if ((versions = info.getVersions()) != null) {
            algorithm.setVersions(versions.stream().map(v -> this.buildAlgorithmVersion(info, (AlgorithmVersionInfo)v)).collect(Collectors.toList()));
        }
        return algorithm;
    }

    private User buildRestUser(String userId) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(ServiceAdapter.getURI());
        Response response = target.path("users").path(userId).request(new String[]{"application/json;charset=UTF-8"}).header("Authorization", (Object)ServiceAdapter.getAutheticationHeader()).get();
        if (response.getStatus() != 200) {
            return null;
        }
        User restUser = (User)response.readEntity(User.class);
        return restUser;
    }

    private AlgorithmVersion buildAlgorithmVersion(AlgorithmInfo algoInfo, AlgorithmVersionInfo versionInfo) {
        AlgorithmVersion version = new AlgorithmVersion();
        version.setId(versionInfo.getId().toString());
        try {
            AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
            AlgorithmConfigurator configurator = service.createAlgorithmConfigurator(algoInfo.getId(), versionInfo.getId());
            version.setDescription(configurator.getDescription());
        }
        catch (RemoteException service) {
            // empty catch block
        }
        RequirementsBuilder mapper = new RequirementsBuilder(algoInfo.getId(), versionInfo.getId(), ClientRemoteLocator.administrationService.getCurrentLocale());
        version.setRequirements(mapper.requirements);
        return version;
    }

    private ibase.rest.model.algorithm.v1.ParameterGroup buildParameterGroup(ParameterGroup group) {
        ibase.rest.model.algorithm.v1.ParameterGroup parameterGroup = new ibase.rest.model.algorithm.v1.ParameterGroup();
        parameterGroup.setParameters(group.getSimpleParameters().stream().map(p -> this.mapper.getFactoryFor(p.getType()).buildParameter((SimpleParameter)p)).collect(Collectors.toList()));
        parameterGroup.setId(group.getName());
        parameterGroup.setLabel(group.getLabel());
        parameterGroup.setCollapsable(Boolean.valueOf(group.isCollapsible()));
        return parameterGroup;
    }

    private AlgorithmConfiguration.ExecutionTypeEnum getExecutionType(ExecutionType type) {
        switch (type) {
            case SIMPLE: {
                return AlgorithmConfiguration.ExecutionTypeEnum.SIMPLE;
            }
            case MULTIPLE: {
                return AlgorithmConfiguration.ExecutionTypeEnum.MULTIPLE;
            }
        }
        return null;
    }

    private AlgorithmInfo getAlgorithmInfo(AlgorithmServiceInterface service, String algorithmId) throws InternalServiceException {
        try {
            AlgorithmInfo algoInfo = service.getInfo((Object)algorithmId);
            return algoInfo != null && !this.userHasPermissionToExecuteAlgorithm(csbase.logic.User.getUserByLogin((String)ServiceAdapter.getCurrenUser()), algoInfo.getName()) ? null : algoInfo;
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
    }

    private boolean userHasPermissionToExecuteAlgorithm(csbase.logic.User user, String algorithmName) {
        try {
            return user.isAdmin() || AlgorithmExecutionPermission.checkSystemAndAlgorithmExecPermission((csbase.logic.User)user, (String)CURRENT_SYSTEM_ID, (String)algorithmName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

