/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.adapter.drmaa2.v1;

import csbase.logic.CommandInfo;
import csbase.logic.CommandSubmission;
import csbase.logic.Priority;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.remote.AlgorithmServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import csbase.remote.SchedulerServiceInterface;
import ibase.common.ServiceAdapter;
import ibase.common.ServiceUtil;
import ibase.exception.InternalServiceException;
import ibase.rest.adapter.drmaa2.v1.JobTemplateValidator;
import ibase.rest.adapter.drmaa2.v1.PersistentMap;
import ibase.rest.api.drmaa2.v1.adapter.Drmaa2ServiceAdapter;
import ibase.rest.model.drmaa2.v1.Job;
import ibase.rest.model.drmaa2.v1.JobSession;
import ibase.rest.model.drmaa2.v1.JobTemplate;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import tecgraf.javautils.core.timestamp.TStamp32;

public class CSBaseDrmaa2ServiceAdapter
implements Drmaa2ServiceAdapter {
    public static final String RESOURCE_BUNDLE = "CSBaseDrmaa2ServiceAdapter";
    private PersistentMap<String, JobSession> jobSessions;

    private PersistentMap<String, JobSession> getJobSessionsMap() {
        if (this.jobSessions == null) {
            this.jobSessions = new PersistentMap("jobsessions.dat");
        }
        return this.jobSessions;
    }

    private boolean isUnique(String sessionName) {
        return !this.getJobSessionsMap().containsKey(sessionName);
    }

    private String generateUniqueSessionName(String userId) {
        return String.format("%s@%s", userId, new TStamp32().toString());
    }

    private ResourceBundle getBundle(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    public void setLocale(Locale locale) {
        ClientRemoteLocator.administrationService.setLocale(locale);
    }

    public JobSession createJobSession(String sessionName) {
        if (!this.isUnique(sessionName)) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(ClientRemoteLocator.administrationService.getCurrentLocale())).message("createJobSession.name.exists.error", new String[]{sessionName});
            throw new InternalServiceException(message);
        }
        String currenUser = ServiceAdapter.getCurrenUser();
        sessionName = sessionName == null ? this.generateUniqueSessionName(currenUser) : sessionName;
        JobSession jobSession = new JobSession();
        jobSession.setSessionName(sessionName);
        return jobSession;
    }

    public JobSession getJobSession(String name) {
        return null;
    }

    public List<JobSession> getAllJobSessions() {
        return null;
    }

    public Job runJob(String jobSessionId, JobTemplate jobTemplate) {
        Object extraProperties;
        List candidateMachines;
        Boolean emailOnTerminated;
        ProjectServiceInterface projectService = ClientRemoteLocator.projectService;
        AlgorithmServiceInterface algorithmService = ClientRemoteLocator.algorithmService;
        if (jobTemplate == null) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(ClientRemoteLocator.administrationService.getCurrentLocale())).message("runJob.jobtemplate.missing.error", new String[0]);
            throw new InternalServiceException(message);
        }
        JobTemplateValidator validator = new JobTemplateValidator(ServiceAdapter.getCurrenUser(), jobTemplate, ClientRemoteLocator.administrationService.getCurrentLocale());
        AlgorithmConfigurator configurator = validator.getAlgorithmConfigurator();
        CommandSubmission submission = new CommandSubmission(configurator, validator.getProjectId());
        submission.setDescription(jobTemplate.getDescription());
        submission.setPriority(Priority.values()[jobTemplate.getPriority()]);
        List emails = jobTemplate.getEmail();
        if (emails != null) {
            submission.setEmailList(emails.toArray(new String[0]));
        }
        if ((emailOnTerminated = jobTemplate.getEmailOnTerminated()) != null) {
            submission.setMailAtEnd(emailOnTerminated.booleanValue());
        }
        if ((candidateMachines = jobTemplate.getCandidateMachines()) != null && candidateMachines.size() > 0) {
            submission.configureSimpleExecution((String)candidateMachines.get(0));
        }
        if ((extraProperties = jobTemplate.getExtraProperties()) != null) {
            LinkedHashMap extraPropertiesMap = (LinkedHashMap)LinkedHashMap.class.cast(extraProperties);
            extraPropertiesMap.forEach((k, v) -> submission.addExtraInfo(k, (String)v));
        }
        Set commandInfos = null;
        SchedulerServiceInterface schedulerService = ClientRemoteLocator.schedulerService;
        try {
            commandInfos = schedulerService.submitCommand(submission);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        CommandInfo cmdInfo = commandInfos.toArray(new CommandInfo[0])[0];
        Job job = new Job();
        job.setJobId(cmdInfo.getId());
        job.setJobOwner(ServiceAdapter.getCurrenUser());
        job.setSubmissionTime(new Date());
        job.setSubmissionMachine(cmdInfo.getSGAName() != null ? cmdInfo.getSGAName() : "");
        return job;
    }
}

