/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.execution_node.v1;

import ibase.rest.api.execution_node.v1.ExecutionNodeApiService;
import ibase.rest.api.execution_node.v1.NotFoundException;
import ibase.rest.api.execution_node.v1.factories.ExecutionNodeApiServiceFactory;
import ibase.rest.model.execution_node.v1.ExecutionNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/execution_node")
@Produces(value={"application/json"})
@Api(description="the execution_node API")
public class ExecutionNodeApi {
    private final ExecutionNodeApiService delegate = ExecutionNodeApiServiceFactory.getExecutionNodeApi();

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List the available execution nodes that match the requirements for an algorithm submission.", notes="This endpoint returns information about the available execution nodes for job execution considering the requirements defined by the algorithm and the platforms provided by end user.\n", response=ExecutionNode.class, responseContainer="List", tags={"Execution Nodes"})
    @ApiResponses(value={@ApiResponse(code=200, message="An array of execution nodes", response=ExecutionNode.class, responseContainer="List"), @ApiResponse(code=200, message="Unexpected error", response=ExecutionNode.class, responseContainer="List")})
    public Response executionNodeGet(@ApiParam(value="The identification of the algorithm", required=true) @QueryParam(value="algorithmId") String algorithmId, @ApiParam(value="The identification of the algorithm version", required=true) @QueryParam(value="versionId") String versionId, @ApiParam(value="A list of selected platforms") @QueryParam(value="platforms") List<String> platforms, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.executionNodeGet(algorithmId, versionId, platforms, locale, securityContext);
    }

    @POST
    @Path(value="/matchmaker")
    @Produces(value={"application/json"})
    @ApiOperation(value="List the available execution nodes for job execution using matchmaker for job requirements.", notes="This endpoint returns information about the available execution nodes for job execution considering the requirements requirements provided by end user.\n", response=ExecutionNode.class, responseContainer="List", tags={"Execution Nodes"})
    @ApiResponses(value={@ApiResponse(code=200, message="An array of execution nodes that match the requirements provided.", response=ExecutionNode.class, responseContainer="List"), @ApiResponse(code=200, message="Unexpected error", response=ExecutionNode.class, responseContainer="List")})
    public Response executionNodeMatchmakerPost(@ApiParam(value="Json object representing the requirements used for matchmaker. If no requirement is provided, the endpoint returns all execution nodes available for the authenticated user.") @FormParam(value="requirements") String requirements, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.executionNodeMatchmakerPost(requirements, locale, securityContext);
    }
}

