/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.project.v1.impl;

import ibase.common.NotFoundException;
import ibase.common.ServiceAdapter;
import ibase.common.ServiceUtil;
import ibase.exception.InvalidParameterException;
import ibase.rest.api.authentication.v1.adapter.AuthenticationService;
import ibase.rest.api.authentication.v1.adapter.ParseException;
import ibase.rest.api.project.v1.ProjectsApiService;
import ibase.rest.api.project.v1.adapter.AccessType;
import ibase.rest.api.project.v1.adapter.ProjectInfo;
import ibase.rest.api.project.v1.adapter.ProjectService;
import ibase.rest.api.project.v1.adapter.SharingType;
import ibase.rest.model.project.v1.FileMetadata;
import ibase.rest.model.project.v1.InlineResponse200;
import ibase.rest.model.project.v1.InlineResponse2001;
import ibase.rest.model.project.v1.Project;
import ibase.rest.model.project.v1.ProjectFile;
import ibase.rest.model.project.v1.TeamMember;
import ibase.rest.model.project.v1.User;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import tecgraf.javautils.core.exception.PermissionException;
import tecgraf.javautils.core.timestamp.TStamp64;

public class ProjectsApiServiceImpl
extends ProjectsApiService {
    private static final String ALL_PROJECTS = "ALL";
    private static final String MY_PROJECTS = "MY";
    private static final String UPLOAD_MULTIPART = "multipart";
    private static final String UPLOAD_RESUMABLE = "resumable";
    public static final String RESOURCE_BUNDLE = "language.ProjectsApi";
    private static final String ROOT = "root";
    public static final String GUEST_ROLE = "guest";
    public static final String GUEST_TAG_PROJECT_VISIBILITY = "#guest";
    public static final String ATTRIBUTE_PROJECT_ID = "projectId";
    public static final String ATTRIBUTE_TEMP_FILE_NAME = "tempFileName";
    public static final String ATTRIBUTE_ORIGINAL_FILE_NAME = "originalFileName";
    private static final String SHARED_PROJECTS = "SHARED";
    private static final Logger logger = Logger.getLogger("ProjectsApi");

    private ResourceBundle getBundle(String localeString) {
        Locale locale = ServiceUtil.getLocale((String)localeString);
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    private User buildRestUser(String userId) {
        Client client = ServiceUtil.getClient();
        WebTarget target = client.target(ServiceAdapter.getURI());
        Response response = target.path("users").path(userId).request(new String[]{"application/json;charset=UTF-8"}).header("Authorization", (Object)ServiceAdapter.getAutheticationHeader()).get();
        if (response.getStatus() != 200) {
            return null;
        }
        User restUser = (User)response.readEntity(User.class);
        return restUser;
    }

    private TeamMember buildRestTeamMember(String userId, boolean editable) {
        User restUser = this.buildRestUser(userId);
        if (restUser == null) {
            return null;
        }
        TeamMember member = new TeamMember();
        member.setId(restUser.getId());
        member.setLogin(restUser.getLogin());
        member.setName(restUser.getName());
        member.setEditable(editable);
        member.setAvatar(restUser.getAvatar());
        return member;
    }

    private Project buildRestProject(ibase.rest.api.project.v1.adapter.Project project) {
        Project restProject = new Project();
        User owner = this.buildRestUser(project.getOwnerId());
        if (owner == null) {
            return null;
        }
        restProject.setOwner(owner);
        restProject.isOwner(project.getOwnerId().equals(ServiceAdapter.getCurrenUser()));
        restProject.setId(ServiceUtil.encodeToBase64((String)project.getId()));
        restProject.setDescription(project.getDescription() == null ? " " : project.getDescription());
        restProject.setName(project.getName());
        restProject.setModified(project.getLastModificationDate());
        restProject.setCreated(project.getCreationDate());
        restProject.setType(project.getType());
        restProject.setVisibility(Project.VisibilityEnum.valueOf(project.getSharingType().name()));
        ArrayList<TeamMember> projectMembers = new ArrayList<TeamMember>();
        project.getTeamMembers(AccessType.READ_ONLY).forEach(u -> {
            TeamMember m = this.buildRestTeamMember((String)u, false);
            if (m != null) {
                projectMembers.add(m);
            }
        });
        project.getTeamMembers(AccessType.READ_WRITE).forEach(u -> {
            TeamMember m = this.buildRestTeamMember((String)u, true);
            if (m != null) {
                projectMembers.add(m);
            }
        });
        restProject.setMembers(projectMembers);
        String userId = ServiceAdapter.getCurrenUser();
        restProject.setEditable(project.isWritableByUser(userId));
        return restProject;
    }

    private ProjectFile buildRestProjectFile(ibase.rest.api.project.v1.adapter.ProjectFile file, boolean showHiddenFiles) {
        ProjectFile projectFile = new ProjectFile();
        String ownerId = file.whoCreated();
        if (ownerId != null) {
            User owner = this.buildRestUser(ownerId);
            if (owner == null) {
                return null;
            }
            projectFile.setCreatedBy(owner);
        }
        projectFile.setCreated(file.getCreationDate());
        projectFile.setDescription(file.getDescription());
        projectFile.setIsFolder(file.isDirectory());
        projectFile.setName(file.getName());
        projectFile.setIsUnderConstruction(file.isUnderConstruction());
        projectFile.setModified(file.getModificationDate());
        projectFile.setPath(file.getId());
        projectFile.setNumberOfChildren(file.isDirectory() != false ? file.getNumberOfChildren(showHiddenFiles) : 0);
        projectFile.setId(this.getFileId(file));
        if (!file.isDirectory().booleanValue()) {
            String mimeType = URLConnection.guessContentTypeFromName(file.getName());
            if (mimeType == null) {
                mimeType = file.getMimeType();
            }
            projectFile.setMimeType(mimeType != null ? mimeType : "content/unknown");
        }
        return projectFile;
    }

    private String getFileId(ibase.rest.api.project.v1.adapter.ProjectFile file) {
        String id = ServiceUtil.encodeToBase64((String)file.getId());
        return "".equals(id) ? ROOT : id;
    }

    private String getFilePath(String fileId) {
        return ROOT.equalsIgnoreCase(fileId) ? "" : ServiceUtil.decodeFromBase64((String)fileId);
    }

    private FileMetadata getFileMetadata(ibase.rest.api.project.v1.adapter.ProjectFile file, boolean showHiddenFiles) throws RemoteException, PermissionException {
        FileMetadata fileMetadata = new FileMetadata();
        ArrayList<ProjectFile> content = new ArrayList<ProjectFile>();
        if (file.isDirectory().booleanValue()) {
            Stream.of(file.getChildren(showHiddenFiles)).forEach(i -> content.add(this.buildRestProjectFile((ibase.rest.api.project.v1.adapter.ProjectFile)i, showHiddenFiles)));
        }
        fileMetadata.setFile(this.buildRestProjectFile(file, showHiddenFiles));
        fileMetadata.setContent(content);
        return fileMetadata;
    }

    private byte[] toArray(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        byte[] byteArray = buffer.toByteArray();
        return byteArray;
    }

    @Override
    public Response projectsGet(String name, String subset, Boolean onlyEditable, String locale, SecurityContext securityContext) {
        try {
            subset = subset == null || subset.isEmpty() ? ALL_PROJECTS : subset.toUpperCase();
            boolean onlyWritable = onlyEditable == null ? false : onlyEditable;
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.list.info", new String[]{subset, name}));
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            if (!(subset.equalsIgnoreCase(ALL_PROJECTS) || subset.equalsIgnoreCase(MY_PROJECTS) || subset.equalsIgnoreCase(SHARED_PROJECTS))) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.get.invalid.subset", new String[0]));
            }
            ArrayList<ProjectInfo> projects = new ArrayList<ProjectInfo>();
            String userId = ServiceAdapter.getCurrenUser();
            switch (subset) {
                case "ALL": {
                    if (userId.equals("admin")) {
                        projects.addAll(projectService.getAllProjects(userId));
                        break;
                    }
                    projects.addAll(projectService.getProjectsCreatedBy(userId));
                    projects.addAll(projectService.getProjectsSharedWith(userId));
                    break;
                }
                case "MY": {
                    projects.addAll(projectService.getProjectsCreatedBy(userId));
                    break;
                }
                case "SHARED": {
                    projects.addAll(projectService.getProjectsSharedWith(userId));
                }
            }
            User currentUser = this.buildRestUser(ServiceAdapter.getCurrenUser());
            boolean isGuest = currentUser.getRoles().contains(GUEST_ROLE);
            ArrayList<Project> projectList = new ArrayList<Project>();
            for (ProjectInfo pi : projects) {
                if (isGuest && !pi.getDescription().contains(GUEST_TAG_PROJECT_VISIBILITY) || name != null && !pi.getName().toLowerCase().contains(name.toLowerCase()) || onlyWritable && !pi.isWritableByUser(userId).booleanValue()) continue;
                Project restProject = this.buildRestProject(projectService.getProject(pi.getId()));
                if (restProject != null) {
                    projectList.add(restProject);
                    continue;
                }
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.creation.user.not.found.error", new String[0]));
            }
            return Response.ok().entity(projectList).build();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsPost(String name, String description, String type, String visibility, String locale, SecurityContext securityContext) {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.creation.info", new String[]{name, visibility}));
            visibility = visibility == null ? SharingType.PRIVATE.name() : visibility.toUpperCase();
            try {
                SharingType.valueOf(visibility);
            }
            catch (IllegalArgumentException e) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.creation.invalid.visibility", new String[0]));
            }
            String userId = ServiceAdapter.getCurrenUser();
            ibase.rest.api.project.v1.adapter.Project newProject = projectService.createProject(name, userId, description, type, SharingType.valueOf(visibility));
            Project restProject = this.buildRestProject(newProject);
            if (restProject != null) {
                return Response.status((Response.Status)Response.Status.CREATED).entity((Object)restProject).build();
            }
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.creation.user.not.found.error", new String[0]));
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdGet(String projectId, String locale, SecurityContext securityContext) {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.findById.info", new String[]{projectId}));
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            if (projectId.trim().isEmpty()) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.id.invalid.error", new String[0]));
            }
            ibase.rest.api.project.v1.adapter.Project project = projectService.getProject(projectId);
            if (project != null) {
                return Response.ok().entity((Object)this.buildRestProject(project)).build();
            }
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (NotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Override
    public Response projectsProjectIdPut(String projectId, String locale, String description, String type, String visibility, SecurityContext securityContext) throws NotFoundException {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.update.info", new String[]{ServiceUtil.decodeFromBase64((String)projectId)}));
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            if (description == null && visibility == null && type == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.update.invalid.parameters", new String[0]));
            }
            SharingType sharingType = null;
            if (visibility != null) {
                try {
                    sharingType = SharingType.valueOf(visibility.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.update.invalid.visibility", new String[0]));
                }
            }
            ibase.rest.api.project.v1.adapter.Project project = projectService.updateProject(projectId, description, type, sharingType);
            return Response.ok().entity((Object)this.buildRestProject(project)).build();
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (NotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdDelete(String projectId, String locale, SecurityContext securityContext) {
        try {
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.delete.info", new String[]{ServiceUtil.decodeFromBase64((String)projectId)}));
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            projectService.removeProject(ServiceUtil.decodeFromBase64((String)projectId));
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (NotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdMembersGet(String projectId, String locale, SecurityContext securityContext) throws NotFoundException {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.members.get.info", new String[]{ServiceUtil.decodeFromBase64((String)projectId)}));
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            ibase.rest.api.project.v1.adapter.Project project = projectService.getProject(projectId);
            ArrayList projectMembers = new ArrayList();
            project.getTeamMembers(AccessType.READ_ONLY).forEach(u -> {
                TeamMember m = this.buildRestTeamMember((String)u, true);
                if (m != null) {
                    projectMembers.add(m);
                }
            });
            project.getTeamMembers(AccessType.READ_WRITE).forEach(u -> {
                TeamMember m = this.buildRestTeamMember((String)u, false);
                if (m != null) {
                    projectMembers.add(m);
                }
            });
            return Response.ok().entity(projectMembers).build();
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (NotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdMembersUserIdDelete(String projectId, String userId, String locale, SecurityContext securityContext) {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.members.delete.info", new String[]{ServiceUtil.decodeFromBase64((String)projectId)}));
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            if (userId == null || this.buildRestUser(userId) == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.user.not.found.error", new String[]{userId}));
            }
            ibase.rest.api.project.v1.adapter.Project project = projectService.getProject(projectId);
            if (!project.getSharingType().equals((Object)SharingType.SELECTIVE)) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.members.update.invalid.error", new String[0]));
            }
            if (!project.removeTeamMember(userId)) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.member.delete.error", new String[]{userId}));
            }
            return Response.noContent().build();
        }
        catch (PermissionException p) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.write.permission.error", new String[0]));
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (NotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdMembersUserIdPut(String projectId, String userId, Boolean editable, String locale, SecurityContext securityContext) throws NotFoundException {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.members.update.info", new String[]{ServiceUtil.decodeFromBase64((String)projectId)}));
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            if (userId == null || this.buildRestUser(userId) == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.user.not.found.error", new String[]{userId}));
            }
            ibase.rest.api.project.v1.adapter.Project project = projectService.getProject(projectId);
            if (!project.getSharingType().equals((Object)SharingType.SELECTIVE)) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.members.update.invalid.error", new String[0]));
            }
            if (project.getOwnerId().equals(userId)) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.owner.cannot.be.member.error", new String[0]));
            }
            if (editable == null) {
                editable = false;
            }
            if (!editable.booleanValue()) {
                project.addTeamMember(AccessType.READ_ONLY, userId);
            } else {
                project.addTeamMember(AccessType.READ_WRITE, userId);
            }
            TeamMember member = this.buildRestTeamMember(userId, editable);
            if (member != null) {
                return Response.ok().entity((Object)member).build();
            }
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.member.not.found.error", new String[]{userId}));
        }
        catch (PermissionException p) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.write.permission.error", new String[0]));
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (NotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdMembersUserIdGet(String projectId, String userId, String locale, SecurityContext securityContext) throws NotFoundException {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.members.user.get.info", new String[]{projectId}));
            if (userId == null || this.buildRestUser(userId) == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.user.not.found.error", new String[]{userId}));
            }
            ibase.rest.api.project.v1.adapter.Project project = projectService.getProject(projectId);
            AccessType accessType = project.getUserAccessType(userId);
            if (accessType == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.member.not.found.error", new String[]{userId}));
            }
            switch (accessType) {
                case READ_ONLY: {
                    TeamMember member = this.buildRestTeamMember(userId, false);
                    if (member == null) break;
                    return Response.ok().entity((Object)member).build();
                }
                case READ_WRITE: {
                    TeamMember member = this.buildRestTeamMember(userId, true);
                    if (member == null) break;
                    return Response.ok().entity((Object)member).build();
                }
            }
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.member.not.found.error", new String[]{userId}));
        }
        catch (PermissionException p) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.write.permission.error", new String[0]));
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (NotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdFilesFileIdGet(String projectId, String fileId, String locale, SecurityContext securityContext) {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            fileId = this.getFilePath(fileId);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.download.info", new String[]{projectId, fileId}));
            ibase.rest.api.project.v1.adapter.ProjectFile file = projectService.getProjectFile(projectId, fileId);
            FileMetadata fileMetadata = this.getFileMetadata(file, true);
            if (fileMetadata.getFile().getIsFolder().booleanValue()) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.folder.download.forbiden", new String[0]));
            }
            final InputStream is = file.getInputStream();
            StreamingOutput output = new StreamingOutput(){

                public void write(OutputStream out) throws IOException {
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = is.read(buffer)) != -1) {
                        out.write(buffer, 0, length);
                    }
                    out.flush();
                    is.close();
                }
            };
            return Response.ok((Object)output).type(fileMetadata.getFile().getMimeType()).header("Content-Disposition", (Object)("filename=\"" + fileMetadata.getFile().getName() + "\"")).build();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (NotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdFilesFileIdPost(String sourceProjectId, String folderId, InputStream inputStream, FormDataContentDisposition fileDetail, String uploadType, String uploadId, Long rangeStart, Long rangeEnd, Long totalSize, String locale, SecurityContext securityContext) {
        ibase.rest.api.project.v1.adapter.ProjectFile file = null;
        try {
            Response response;
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            String projectId = ServiceUtil.decodeFromBase64((String)sourceProjectId);
            folderId = this.getFilePath(folderId);
            String fileName = fileDetail.getFileName();
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.info", new String[]{projectId, folderId}));
            if (uploadType == null) {
                Response response2 = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.type.missing.error", new String[0]));
                return response2;
            }
            boolean uploadMultipart = false;
            if (UPLOAD_MULTIPART.equalsIgnoreCase(uploadType)) {
                uploadMultipart = true;
            } else if (!UPLOAD_RESUMABLE.equalsIgnoreCase(uploadType)) {
                Response e = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.type.missing.error", new String[0]));
                return e;
            }
            ibase.rest.api.project.v1.adapter.ProjectFile folder = projectService.getProjectFile(projectId, folderId);
            if (folder == null) {
                Response e = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.folder.invalid.error", new String[0]));
                return e;
            }
            if (uploadMultipart) {
                if (folder.containsChild(fileName)) {
                    file = folder.getChild(fileName);
                    if (file.isDirectory().booleanValue()) {
                        Response e = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.name.usedby.folder", new String[]{fileName}));
                        return e;
                    }
                } else {
                    file = folder.createFile(fileName, ServiceUtil.getLocale((String)locale));
                }
                try {
                    OutputStream out = file.getOutputStream();
                    int read = 0;
                    byte[] bytes = new byte[1024];
                    while ((read = inputStream.read(bytes)) != -1) {
                        out.write(bytes, 0, read);
                    }
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    throw new InternalServerErrorException((Throwable)e);
                }
                InlineResponse200 inlineResponse = new InlineResponse200();
                inlineResponse.setFileId(this.getFileId(file));
                Response read = Response.ok().entity((Object)inlineResponse).build();
                return read;
            }
            String tempFileName = null;
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            if (uploadId == null) {
                tempFileName = ".rest_" + new TStamp64().toString();
                Calendar c = Calendar.getInstance();
                c.add(1, 10);
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put(ATTRIBUTE_ORIGINAL_FILE_NAME, fileDetail.getFileName());
                attributes.put(ATTRIBUTE_PROJECT_ID, sourceProjectId);
                attributes.put(ATTRIBUTE_TEMP_FILE_NAME, folderId + File.separator + tempFileName);
                uploadId = authenticationService.createToken(null, attributes, c.getTime());
                file = folder.createFile(tempFileName, ServiceUtil.getLocale((String)locale));
            } else {
                HashMap attributes = new HashMap();
                try {
                    authenticationService.parserToken(uploadId, attributes);
                }
                catch (ParseException e) {
                    Response response3 = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.invalid.token.error", new String[0]));
                    if (file != null) {
                        try {
                            file.close(true);
                        }
                        catch (IOException e2) {
                            throw new InternalServerErrorException((Throwable)e2);
                        }
                    }
                    return response3;
                }
                tempFileName = (String)attributes.get(ATTRIBUTE_TEMP_FILE_NAME);
                String tokenRealFileName = (String)attributes.get(ATTRIBUTE_ORIGINAL_FILE_NAME);
                String receivedProjectId = (String)attributes.get(ATTRIBUTE_PROJECT_ID);
                if (tempFileName == null || receivedProjectId == null || tokenRealFileName == null) {
                    Response e2 = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.invalid.token.error", new String[0]));
                    return e2;
                }
                if (!tokenRealFileName.equals(fileDetail.getFileName()) || !receivedProjectId.equals(sourceProjectId)) {
                    Response e2 = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.invalid.token.error", new String[0]));
                    return e2;
                }
                file = projectService.getProjectFile(ServiceUtil.decodeFromBase64((String)receivedProjectId), tempFileName);
            }
            file.open(false);
            int chunck_size = (int)(rangeEnd - rangeStart);
            file.write(this.toArray(inputStream), 0, chunck_size, rangeStart);
            if (file.size() + (long)chunck_size == totalSize) {
                if (folder.containsChild(fileName)) {
                    ibase.rest.api.project.v1.adapter.ProjectFile toRemoveFile = folder.getChild(fileName);
                    if (toRemoveFile.isDirectory().booleanValue()) {
                        response = ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.upload.name.usedby.folder", new String[]{fileName}));
                        return response;
                    }
                    toRemoveFile.remove();
                }
                file.close(false);
                file.rename(fileDetail.getFileName());
            } else {
                file.close(false);
            }
            InlineResponse200 inlineResponse = new InlineResponse200();
            inlineResponse.setUploadId(uploadId);
            inlineResponse.setFileId(this.getFileId(file));
            response = Response.ok().entity((Object)inlineResponse).build();
            return response;
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
        finally {
            if (file != null) {
                try {
                    file.close(true);
                }
                catch (IOException e) {
                    throw new InternalServerErrorException((Throwable)e);
                }
            }
        }
    }

    @Override
    public Response projectsProjectIdFilesFileIdDelete(String projectId, String fileId, String locale, SecurityContext securityContext) {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            fileId = ServiceUtil.decodeFromBase64((String)fileId);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.files.delete.info", new String[]{projectId}));
            ibase.rest.api.project.v1.adapter.ProjectFile file = projectService.getProjectFile(projectId, fileId);
            file.remove();
            return Response.noContent().build();
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (NotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdFilesFileIdLinkGet(String projectId, String fileId, String locale, SecurityContext securityContext) {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            ibase.rest.api.project.v1.adapter.ProjectFile file = projectService.getProjectFile(ServiceUtil.decodeFromBase64((String)projectId), this.getFilePath(fileId));
            FileMetadata fileMetadata = this.getFileMetadata(file, true);
            StringBuilder builder = new StringBuilder();
            builder.append(ServiceAdapter.getURI());
            builder.append("/links/download/");
            String userId = ServiceAdapter.getCurrenUser();
            builder.append(authenticationService.createToken(userId, null, new Date(System.currentTimeMillis() + 30000L)));
            builder.append("/");
            builder.append(projectId);
            builder.append("/");
            builder.append(fileId);
            InlineResponse2001 response = new InlineResponse2001();
            response.setUrl(builder.toString());
            response.setFileName(fileMetadata.getFile().getName());
            response.setMimeType(fileMetadata.getFile().getMimeType());
            return Response.ok().entity((Object)response).build();
        }
        catch (PermissionException p) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.read.permission.error", new String[0]));
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdFilesFileIdMetadataGet(String projectId, String fileId, Boolean showHiddenFiles, String locale, SecurityContext securityContext) {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            showHiddenFiles = showHiddenFiles == null ? false : showHiddenFiles;
            fileId = this.getFilePath(fileId);
            ibase.rest.api.project.v1.adapter.ProjectFile file = projectService.getProjectFile(projectId, fileId);
            FileMetadata fileMetadata = this.getFileMetadata(file, showHiddenFiles);
            return Response.ok().entity((Object)fileMetadata).build();
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (NotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsProjectIdFilesFileIdFolderPost(String projectId, String fileId, String name, String locale, SecurityContext securityContext) throws NotFoundException {
        try {
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            fileId = this.getFilePath(fileId);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.folder.create.info", new String[]{projectId}));
            if (name == null || name.isEmpty()) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.folder.create.name.empty", new String[0]));
            }
            ibase.rest.api.project.v1.adapter.ProjectFile targetFolder = projectService.getProjectFile(projectId, fileId);
            if (!targetFolder.isDirectory().booleanValue()) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.folder.create.target.invalid", new String[0]));
            }
            if (targetFolder.containsChild(name)) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.folder.create.name.invalid", new String[]{name}));
            }
            ibase.rest.api.project.v1.adapter.ProjectFile newDirectory = projectService.createFolder(projectId, fileId, name);
            ProjectFile folder = this.buildRestProjectFile(newDirectory, true);
            return Response.ok().entity((Object)folder).build();
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (NotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)e.getMessage());
        }
        catch (PermissionException p) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.file.write.permission.error", new String[0]));
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsFileopsCopyPost(String sourceProjectId, String targetProjectId, String targetFileId, String sourceFileId, String locale, SecurityContext securityContext) throws NotFoundException {
        try {
            if (sourceProjectId == null || sourceProjectId.isEmpty() || sourceFileId == null || sourceFileId.isEmpty() || targetProjectId == null || targetProjectId.isEmpty() || targetFileId == null || targetFileId.isEmpty()) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.fileops.copy.info", new String[0]);
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)message);
            }
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            sourceFileId = ROOT.equalsIgnoreCase(sourceFileId) ? "" : ServiceUtil.decodeFromBase64((String)sourceFileId);
            targetFileId = ROOT.equalsIgnoreCase(targetFileId) ? "" : ServiceUtil.decodeFromBase64((String)targetFileId);
            sourceProjectId = ServiceUtil.decodeFromBase64((String)sourceProjectId);
            targetProjectId = ServiceUtil.decodeFromBase64((String)targetProjectId);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.fileops.copy.info", new String[]{sourceProjectId, sourceFileId, targetProjectId, targetFileId}));
            if (!projectService.existsProjectFile(sourceProjectId, sourceFileId)) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.copy.source.not.found", new String[]{sourceProjectId, sourceFileId});
                return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)message);
            }
            if (!projectService.existsProjectFile(targetProjectId, targetFileId)) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.copy.target.not.found", new String[]{targetProjectId, targetFileId});
                return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)message);
            }
            ibase.rest.api.project.v1.adapter.ProjectFile source = projectService.getProjectFile(sourceProjectId, sourceFileId);
            String sourceName = source.getName();
            ibase.rest.api.project.v1.adapter.ProjectFile target = projectService.getProjectFile(targetProjectId, targetFileId);
            if (!target.isDirectory().booleanValue()) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.copy.target.not.folder", new String[0]);
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)message);
            }
            projectService.copyFile(sourceProjectId, sourceFileId, targetProjectId, targetFileId);
            ibase.rest.api.project.v1.adapter.ProjectFile resultFile = target.getChild(sourceName);
            ProjectFile fileAfterCopy = this.buildRestProjectFile(resultFile, true);
            return Response.ok().entity((Object)fileAfterCopy).build();
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsFileopsMovePost(String sourceProjectId, String targetProjectId, String targetFileId, String sourceFileId, String locale, SecurityContext securityContext) throws NotFoundException {
        try {
            if (sourceProjectId == null || sourceProjectId.isEmpty() || sourceFileId == null || sourceFileId.isEmpty() || targetProjectId == null || targetProjectId.isEmpty() || targetFileId == null || targetFileId.isEmpty()) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.move.empty.parameters", new String[0]);
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)message);
            }
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            sourceFileId = ROOT.equalsIgnoreCase(sourceFileId) ? "" : ServiceUtil.decodeFromBase64((String)sourceFileId);
            targetFileId = ROOT.equalsIgnoreCase(targetFileId) ? "" : ServiceUtil.decodeFromBase64((String)targetFileId);
            sourceProjectId = ServiceUtil.decodeFromBase64((String)sourceProjectId);
            targetProjectId = ServiceUtil.decodeFromBase64((String)targetProjectId);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.fileops.move.info", new String[]{sourceProjectId, sourceFileId, targetProjectId, targetFileId}));
            if (!projectService.existsProjectFile(sourceProjectId, sourceFileId)) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.move.source.not.found", new String[]{sourceProjectId, sourceFileId});
                return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)message);
            }
            if (!projectService.existsProjectFile(targetProjectId, targetFileId)) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.move.target.not.found", new String[]{targetProjectId, targetFileId});
                return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)message);
            }
            ibase.rest.api.project.v1.adapter.ProjectFile source = projectService.getProjectFile(sourceProjectId, sourceFileId);
            String sourceName = source.getName();
            ibase.rest.api.project.v1.adapter.ProjectFile target = projectService.getProjectFile(targetProjectId, targetFileId);
            if (!target.isDirectory().booleanValue()) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.move.target.not.folder", new String[0]);
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)message);
            }
            projectService.moveFile(sourceProjectId, sourceFileId, targetProjectId, targetFileId);
            ibase.rest.api.project.v1.adapter.ProjectFile resultFile = target.getChild(sourceName);
            ProjectFile fileAfterMove = this.buildRestProjectFile(resultFile, true);
            return Response.ok().entity((Object)fileAfterMove).build();
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsFileopsRenamePost(String projectId, String fileId, String name, String locale, SecurityContext securityContext) {
        try {
            if (projectId == null || projectId.isEmpty() || fileId == null || fileId.isEmpty()) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.fileops.rename.empty.parameters", new String[0]);
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)message);
            }
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            fileId = ROOT.equalsIgnoreCase(fileId) ? "" : ServiceUtil.decodeFromBase64((String)fileId);
            projectId = ServiceUtil.decodeFromBase64((String)projectId);
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.fileops.rename.info", new String[]{projectId, fileId, name}));
            if (!projectService.existsProjectFile(projectId, fileId)) {
                String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.fileops.rename.file.not.found", new String[]{projectId, fileId});
                return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)message);
            }
            ibase.rest.api.project.v1.adapter.ProjectFile resultFile = projectService.renameFile(projectId, fileId, name);
            ProjectFile fileAfterMove = this.buildRestProjectFile(resultFile, true);
            return Response.ok().entity((Object)fileAfterMove).build();
        }
        catch (InvalidParameterException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)e.getMessage());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response projectsFileopsCancelUploadPost(String uploadId, String locale, SecurityContext securityContext) throws NotFoundException {
        try {
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            HashMap attributes = new HashMap();
            try {
                authenticationService.parserToken(uploadId, attributes);
            }
            catch (ParseException e) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.fileops.cancelupload.id.invalid", new String[0]));
            }
            String tempFileName = (String)attributes.get(ATTRIBUTE_TEMP_FILE_NAME);
            String receivedProjectId = (String)attributes.get(ATTRIBUTE_PROJECT_ID);
            String projectId = ServiceUtil.decodeFromBase64((String)receivedProjectId);
            ProjectService projectService = (ProjectService)ServiceAdapter.getInstance(ProjectService.class, (String)locale);
            if (projectService.existsProjectFile(projectId, tempFileName)) {
                ibase.rest.api.project.v1.adapter.ProjectFile file = projectService.getProjectFile(projectId, tempFileName);
                file.remove();
            }
            return Response.ok().build();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("project.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }
}

