/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.client.v2.impl;

import ibase.common.v2.RestErrorMessage;
import ibase.common.v2.ServiceAdapter;
import ibase.common.v2.ServiceUtil;
import ibase.rest.api.client.v2.ClientApiService;
import ibase.rest.api.client.v2.NotFoundException;
import ibase.rest.api.client.v2.adapter.ClientService;
import ibase.rest.api.client.v2.adapter.UnauthorizedException;
import ibase.rest.model.client.v2.UrlToken;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public class ClientApiServiceImpl
extends ClientApiService {
    private static final Logger logger = Logger.getLogger("ClientApi");
    public static final String RESOURCE_BUNDLE = "language.v2.ClientApi";

    private ResourceBundle getBundle(String localeString) {
        Locale locale = ServiceUtil.getLocale((String)localeString);
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    @Override
    public Response clientLauncherGet(String localeString, String desktopVisible, SecurityContext securityContext) throws NotFoundException {
        ClientService launcherService = (ClientService)ServiceAdapter.getInstance(ClientService.class, (String)localeString);
        Locale locale = ServiceUtil.getLocale((String)localeString);
        Boolean visible = null;
        if (desktopVisible != null && !desktopVisible.isEmpty()) {
            visible = desktopVisible.equals("true") ? Boolean.TRUE : Boolean.FALSE;
        }
        try {
            String authorizationHeader = ServiceAdapter.getAutheticationHeader();
            if (authorizationHeader == null || !authorizationHeader.startsWith("Bearer ")) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new RestErrorMessage("Authorization header must be provided")).build();
            }
            String token = authorizationHeader.substring("Bearer".length()).trim();
            UrlToken url = launcherService.getClientPreLoginURL(token, locale, visible);
            return Response.ok().entity((Object)url).build();
        }
        catch (UnauthorizedException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.UNAUTHORIZED, (Logger)logger, (Exception)e);
        }
        catch (Exception e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)e);
        }
    }

    @Override
    public Response clientRestTokenGet(String clientToken, String localeString, SecurityContext securityContext) throws NotFoundException {
        ClientService launcherService = (ClientService)ServiceAdapter.getInstance(ClientService.class, (String)localeString);
        if (clientToken == null || clientToken.isEmpty()) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(localeString)).message("authentication.clientToken.parameter.missing.error", new String[0]));
        }
        Locale locale = ServiceUtil.getLocale((String)localeString);
        try {
            String url = launcherService.getClientHttpServerURL(clientToken, locale);
            return Response.ok().entity((Object)url).build();
        }
        catch (Exception e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)e);
        }
    }
}

