/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.job.v2;

import ibase.rest.api.job.v2.JobsApiService;
import ibase.rest.api.job.v2.NotFoundException;
import ibase.rest.api.job.v2.factories.JobsApiServiceFactory;
import ibase.rest.model.job.v2.InlineResponse200;
import ibase.rest.model.job.v2.Job;
import ibase.rest.model.job.v2.JobSession;
import ibase.rest.model.job.v2.JobTemplate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/jobs")
@Produces(value={"application/json;"})
@Api(description="the jobs API")
public class JobsApi {
    private final JobsApiService delegate = JobsApiServiceFactory.getJobsApi();

    @GET
    @Produces(value={"application/json;"})
    @ApiOperation(value="Fetch filtered list of jobs.", notes="This endpoint list all jobs that match the parameters criteria", response=InlineResponse200.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=InlineResponse200.class), @ApiResponse(code=403, message="if the authenticated user does not have permission to access the project.", response=InlineResponse200.class)})
    public Response jobsGet(@ApiParam(value="The query in RSQL format.") @QueryParam(value="q") String q, @ApiParam(value="Temporary workaround to just load a cache in server without return anything. Will be remove in future version. Default false.") @QueryParam(value="cacheOnly") Boolean cacheOnly, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsGet(q, cacheOnly, locale, securityContext);
    }

    @GET
    @Path(value="/{jobId}/flow/raw")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Get the flow`s raw.", notes="This endpoint get the flow raw", response=void.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=void.class), @ApiResponse(code=404, message="The job was not found.", response=void.class)})
    public Response jobsJobIdFlowRawGet(@ApiParam(value="The ID of the job.", required=true) @PathParam(value="jobId") String jobId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsJobIdFlowRawGet(jobId, locale, securityContext);
    }

    @GET
    @Path(value="/{jobId}")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Get a job information.", notes="This endpoint lists a job information.", response=Job.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=Job.class)})
    public Response jobsJobIdGet(@ApiParam(value="The ID of the job.", required=true) @PathParam(value="jobId") String jobId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsJobIdGet(jobId, locale, securityContext);
    }

    @GET
    @Path(value="/{jobId}/log/{fileId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get the job log output file.", notes="This endpoint list the job output log.", response=File.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=File.class), @ApiResponse(code=404, message="The log output file was not found", response=File.class), @ApiResponse(code=500, message="Processing error occurred accessing the log output file", response=File.class)})
    public Response jobsJobIdLogFileIdGet(@ApiParam(value="The ID of the job.", required=true) @PathParam(value="jobId") String jobId, @ApiParam(value="The ID of the file.", required=true) @PathParam(value="fileId") String fileId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsJobIdLogFileIdGet(jobId, fileId, locale, securityContext);
    }

    @GET
    @Path(value="/{jobId}/log")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Get the job log output file.", notes="This endpoint list the job output log.", response=File.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=File.class), @ApiResponse(code=404, message="The log output file was not found", response=File.class), @ApiResponse(code=500, message="Processing error occurred accessing the log output file", response=File.class)})
    public Response jobsJobIdLogGet(@ApiParam(value="The ID of the job.", required=true) @PathParam(value="jobId") String jobId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsJobIdLogGet(jobId, locale, securityContext);
    }

    @GET
    @Path(value="/{jobId}/parameters")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Get the job's parameters.", notes="This endpoint list the job' parameters.", response=Object.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=Object.class), @ApiResponse(code=400, message="The job is not a flow", response=Object.class), @ApiResponse(code=404, message="The job was not found.", response=Object.class)})
    public Response jobsJobIdParametersGet(@ApiParam(value="The ID of the job.", required=true) @PathParam(value="jobId") String jobId, @ApiParam(value="If true, return the parameter value as JSON. If false, use the default csbase text format. Default is false") @QueryParam(value="jsonFormat") Boolean jsonFormat, @ApiParam(value="If true, return a map with parametar name as key and values as map value. If false, return a structure with other param information. Working just to simple algorithm, to flow always returns the complete data. Default true") @QueryParam(value="valuesOnly") Boolean valuesOnly, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsJobIdParametersGet(jobId, jsonFormat, valuesOnly, locale, securityContext);
    }

    @GET
    @Path(value="/jobsession")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Get a list of all job sessions the authenticated user can access.", notes="This endpoint return a list of URIs to all available job sessions. A job session instance acts as container for job instances.", response=JobSession.class, responseContainer="List", tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=JobSession.class, responseContainer="List")})
    public Response jobsJobsessionGet(@ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsJobsessionGet(locale, securityContext);
    }

    @GET
    @Path(value="/jobsession/{jobSessionName}")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Get a job session by its name", notes="This endpoint returns a job session by its name. The name is encoded in Base64.", response=JobSession.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=JobSession.class), @ApiResponse(code=404, message="Job session was not found.", response=JobSession.class)})
    public Response jobsJobsessionJobSessionNameGet(@ApiParam(value="The name of a job session encoded in Base64.", required=true) @PathParam(value="jobSessionName") String jobSessionName, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsJobsessionJobSessionNameGet(jobSessionName, locale, securityContext);
    }

    @POST
    @Path(value="/jobsession")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Create a job session.", notes="This endpoint creates a job session.", response=JobSession.class, responseContainer="List", tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=201, message="The new job session was succesfully created.", response=JobSession.class, responseContainer="List"), @ApiResponse(code=400, message="If the name is empty or if the user already has a job session with the same name", response=JobSession.class, responseContainer="List"), @ApiResponse(code=415, message="Unsupported Media Type", response=JobSession.class, responseContainer="List")})
    public Response jobsJobsessionPost(@ApiParam(value="The name of the job session to be created. This parameter is mandatory.", required=true) @FormParam(value="name") String name, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsJobsessionPost(name, locale, securityContext);
    }

    @POST
    @Path(value="/operation/cancel")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Cancel a job execution.", notes="This endpoint cancel jobs execution. If the job is scheduled, the job is removed from the queue. If the job is already finished, the action has no effect. The operation allows the cancelation of one or more jobs.", response=void.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=void.class), @ApiResponse(code=403, message="if the authenticated user is not authorized to cancel the job. Only the job owner or the administrator can cancel a job.", response=void.class), @ApiResponse(code=500, message="Processing error occurred during the job cancel operation.", response=void.class)})
    public Response jobsOperationCancelPost(@ApiParam(value="The IDs of the jobs to be canceled.", required=true) @FormParam(value="jobIds") List<String> jobIds, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsOperationCancelPost(jobIds, locale, securityContext);
    }

    @POST
    @Produces(value={"application/json;"})
    @ApiOperation(value="Create a job.", notes="This endpoint submits a job for execution,", response=String.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=String.class)})
    public Response jobsPost(@ApiParam(value="The ID of the job session. This parameter is mandatory.", required=true) @QueryParam(value="jobSessionId") String jobSessionId, @ApiParam(value="The job template") JobTemplate jobTemplate, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsPost(jobSessionId, jobTemplate, locale, securityContext);
    }
}

