/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.job.v2.impl;

import ibase.common.v2.ServiceAdapter;
import ibase.common.v2.ServiceUtil;
import ibase.exception.v2.InternalServiceException;
import ibase.exception.v2.PermissionException;
import ibase.rest.api.job.v2.JobsApiService;
import ibase.rest.api.job.v2.NotFoundException;
import ibase.rest.api.job.v2.adapter.JobsServiceAdapter;
import ibase.rest.model.job.v2.InlineResponse200;
import ibase.rest.model.job.v2.Job;
import ibase.rest.model.job.v2.JobSession;
import ibase.rest.model.job.v2.JobTemplate;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;

public class JobsApiServiceImpl
extends JobsApiService {
    public static final String RESOURCE_BUNDLE = "language.v2.JobsApi";
    private static final Logger logger = Logger.getLogger("JobsApi");

    private ResourceBundle getBundle(String localeString) {
        Locale locale = ServiceUtil.getLocale((String)localeString);
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    @Override
    public Response jobsPost(String jobSessionId, JobTemplate jobTemplate, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("JobsPost.info", new String[0]));
        try {
            JobsServiceAdapter service = (JobsServiceAdapter)ServiceAdapter.getInstance(JobsServiceAdapter.class, (String)locale);
            String jobId = service.runJob(jobSessionId, jobTemplate);
            return Response.ok().entity((Object)jobId).type("text/plain").build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response jobsJobsessionGet(String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("JobsJobsessionGet.info", new String[0]));
        try {
            JobsServiceAdapter service = (JobsServiceAdapter)ServiceAdapter.getInstance(JobsServiceAdapter.class, (String)locale);
            List<JobSession> jobSessions = service.getAllJobSessions();
            return Response.ok().entity(jobSessions).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response jobsJobsessionJobSessionNameGet(String jobSessionName, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("JobsJobsessionJobSessionNameGet.info", new String[0]));
        try {
            JobsServiceAdapter service = (JobsServiceAdapter)ServiceAdapter.getInstance(JobsServiceAdapter.class, (String)locale);
            JobSession jobSession = service.getJobSession(jobSessionName);
            return Response.ok().entity((Object)jobSession).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response jobsJobsessionPost(String name, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("JobsJobsessionPost.info", new String[0]));
        try {
            JobsServiceAdapter service = (JobsServiceAdapter)ServiceAdapter.getInstance(JobsServiceAdapter.class, (String)locale);
            JobSession jobSession = service.createJobSession(name);
            return Response.ok().entity((Object)jobSession).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response jobsOperationCancelPost(List<String> jobIds, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("jobsOperationCancelPost.info", new String[0]));
        try {
            JobsServiceAdapter service = (JobsServiceAdapter)ServiceAdapter.getInstance(JobsServiceAdapter.class, (String)locale);
            service.cancelJobs(jobIds);
            return Response.ok().build();
        }
        catch (PermissionException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.FORBIDDEN, (Logger)logger, (Exception)((Object)e));
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response jobsGet(String q, Boolean cacheOnly, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("JobsGet.info", new String[0]));
        try {
            if (cacheOnly == null) {
                cacheOnly = false;
            }
            JobsServiceAdapter service = (JobsServiceAdapter)ServiceAdapter.getInstance(JobsServiceAdapter.class, (String)locale);
            List<Job> jobs = service.getJobs(q);
            InlineResponse200 response = new InlineResponse200();
            response.setProcessingDate(System.currentTimeMillis());
            if (!cacheOnly.booleanValue()) {
                response.setJobs(jobs);
            }
            return Response.ok().entity((Object)response).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response jobsJobIdFlowNodesGet(String jobId, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("JobsJobIdFlowNodesGet.info", new String[0]));
        try {
            JobsServiceAdapter service = (JobsServiceAdapter)ServiceAdapter.getInstance(JobsServiceAdapter.class, (String)locale);
            List<Map<String, Object>> nodesData = service.getFlowNodes(jobId);
            return Response.ok().entity(nodesData).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response jobsJobIdGet(String jobId, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("JobsJobIdGet.info", new String[0]));
        try {
            JobsServiceAdapter service = (JobsServiceAdapter)ServiceAdapter.getInstance(JobsServiceAdapter.class, (String)locale);
            Job job = service.getJob(jobId);
            return Response.ok().entity((Object)job).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response jobsJobIdLogGet(String jobId, String locale, SecurityContext securityContext) throws NotFoundException {
        return this.jobsJobIdLogFileIdGet(jobId, null, locale, securityContext);
    }

    @Override
    public Response jobsJobIdParametersGet(String jobId, Boolean jsonFormat, Boolean valuesOnly, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("JobsJobIdParametersGet.info", new String[0]));
        try {
            if (jsonFormat == null) {
                jsonFormat = false;
            }
            if (valuesOnly == null) {
                valuesOnly = true;
            }
            JobsServiceAdapter service = (JobsServiceAdapter)ServiceAdapter.getInstance(JobsServiceAdapter.class, (String)locale);
            Map<String, Object> params = service.getJobParameters(jobId, jsonFormat, valuesOnly);
            return Response.ok().entity(params).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response jobsJobIdLogFileIdGet(String jobId, String fileId, String locale, SecurityContext securityContext) throws NotFoundException {
        try {
            StringBuffer stringBuffer;
            logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("JobsJobIdLogGet", new String[0]));
            JobsServiceAdapter service = (JobsServiceAdapter)ServiceAdapter.getInstance(JobsServiceAdapter.class, (String)locale);
            if (jobId == null || service.getJob(jobId) == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("job.id.invalid", new String[0]));
            }
            String fileName = null;
            if (fileId != null) {
                fileName = ServiceUtil.decodeFromBase64((String)fileId);
            }
            if ((stringBuffer = service.getLogFile(jobId, fileName)) == null) {
                return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("job.log.not.found", new String[0]));
            }
            StreamingOutput output = new StreamingOutput(){

                public void write(OutputStream out) throws IOException {
                    out.write(stringBuffer.toString().getBytes());
                    out.flush();
                    out.close();
                }
            };
            return Response.ok((Object)output).build();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("user.internal.server.error", new String[0]), e);
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public Response jobsJobIdFlowRawGet(String jobId, String locale, SecurityContext securityContext) throws NotFoundException {
        ByteBuffer buffer;
        JobsServiceAdapter service = (JobsServiceAdapter)ServiceAdapter.getInstance(JobsServiceAdapter.class, (String)locale);
        try {
            buffer = service.getFlowRaw(jobId);
        }
        catch (IllegalArgumentException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("jobsJobIdFlowRawGet.flow.error", new String[0]));
        }
        catch (Exception e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (Exception)e);
        }
        StreamingOutput output = new StreamingOutput(){

            public void write(OutputStream out) throws IOException {
                out.write(buffer.array());
                out.flush();
                out.close();
            }
        };
        return Response.ok((Object)output).build();
    }
}

