/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.job.v2;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An execution node (algorithm) that is part of a flow.")
public class FlowNodeTemplate {
    private Integer nodeId = null;
    private String algorithmId = null;
    private String versionId = null;

    public FlowNodeTemplate nodeId(Integer nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the node in the flow.")
    public Integer getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(Integer nodeId) {
        this.nodeId = nodeId;
    }

    public FlowNodeTemplate algorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
        return this;
    }

    @ApiModelProperty(value="Id of the node algorithm.")
    public String getAlgorithmId() {
        return this.algorithmId;
    }

    public void setAlgorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
    }

    public FlowNodeTemplate versionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    @ApiModelProperty(value="Version of the node algorithm.")
    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowNodeTemplate flowNodeTemplate = (FlowNodeTemplate)o;
        return Objects.equals(this.nodeId, flowNodeTemplate.nodeId) && Objects.equals(this.algorithmId, flowNodeTemplate.algorithmId) && Objects.equals(this.versionId, flowNodeTemplate.versionId);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.algorithmId, this.versionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlowNodeTemplate {\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.nodeId)).append("\n");
        sb.append("    algorithmId: ").append(this.toIndentedString(this.algorithmId)).append("\n");
        sb.append("    versionId: ").append(this.toIndentedString(this.versionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

