/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.project.v2;

import ibase.rest.api.project.v2.NotFoundException;
import ibase.rest.api.project.v2.ProjectsApiService;
import ibase.rest.api.project.v2.factories.ProjectsApiServiceFactory;
import ibase.rest.model.project.v2.FileMetadata;
import ibase.rest.model.project.v2.Project;
import ibase.rest.model.project.v2.ProjectFile;
import ibase.rest.model.project.v2.SuccessfulGetFileIdLink;
import ibase.rest.model.project.v2.SuccessfulGetFilesLink;
import ibase.rest.model.project.v2.SuccessfulUploadFile;
import ibase.rest.model.project.v2.TeamMember;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/projects")
@Produces(value={"application/json;"})
@Api(description="the projects API")
public class ProjectsApi {
    private final ProjectsApiService delegate = ProjectsApiServiceFactory.getProjectsApi();

    @POST
    @Path(value="/fileops/cancel_upload")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Cancel a resumable session upload. This will clean all temporary file in the server.", notes="", response=void.class, tags={"Project Files"})
    @ApiResponses(value={@ApiResponse(code=200, message="Deleted", response=void.class)})
    public Response projectsFileopsCancelUploadPost(@ApiParam(value="Upload session Id. ") @FormParam(value="uploadId") String uploadId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsFileopsCancelUploadPost(uploadId, locale, securityContext);
    }

    @POST
    @Path(value="/fileops/copy")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Copy a file or a folder to another path in the same project or a different one.", notes="The source path can be a file or a folder. If the source path is folder, its content will be copied too. The target path must be a folder. If the target path is empty, the copy will be done into project root.", response=ProjectFile.class, tags={"Project Files"})
    @ApiResponses(value={@ApiResponse(code=200, message="If the operation is completed with success.", response=ProjectFile.class), @ApiResponse(code=400, message="An invalid copy operation was attempted. For examples, if a mandatory parameter is empty or if the target file is not a folder or if already exists a file or folder with the same name in the target folder or if the copy operation results a infinite loop or if the *sourceFileId*_/_*targetFileId* supplied is invalid.", response=ProjectFile.class), @ApiResponse(code=403, message="if the authenticated user is not authorized to read in the source project or to write in the target project.", response=ProjectFile.class), @ApiResponse(code=404, message="If the source file or the target folder was not found.", response=ProjectFile.class)})
    public Response projectsFileopsCopyPost(@ApiParam(value="The Id of the source project. The ID is encoded in Base64.", required=true) @FormParam(value="sourceProjectId") String sourceProjectId, @ApiParam(value="The Id of the file or folder to be copied. The ID is encoded in Base64.", required=true) @FormParam(value="sourceFileId") String sourceFileId, @ApiParam(value="the Id of the target project. The ID is encoded in Base64.", required=true) @FormParam(value="targetProjectId") String targetProjectId, @ApiParam(value="The Id of the folder in the target project. The target path *root* maps to the project root folder, otherwise, the ID is encoded in Base64.", required=true) @FormParam(value="targetFileId") String targetFileId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsFileopsCopyPost(sourceProjectId, sourceFileId, targetProjectId, targetFileId, locale, securityContext);
    }

    @POST
    @Path(value="/fileops/move")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Move a file or a folder to another path in the same project or a different one.", notes="The source path can be a file or a folder. If the source path is folder, its content will be moved too. The target path must be a folder. If the target path is empty, the move will be done into project root.", response=ProjectFile.class, tags={"Project Files"})
    @ApiResponses(value={@ApiResponse(code=200, message="If the operation is completed with success.", response=ProjectFile.class), @ApiResponse(code=400, message="An invalid move operation was attempted. For examples, if a mandatory parameter is empty or if the target file is not a folder or if already exists a file or folder with the same name in the target folder or if the move operation results a infinite loop or if the *sourceFileId*_/_*targetFileId* supplied is invalid.", response=ProjectFile.class), @ApiResponse(code=403, message="if the authenticated user is not authorized to write in the source project or to write in the target project.", response=ProjectFile.class), @ApiResponse(code=404, message="If the source file or the target folder was not found.", response=ProjectFile.class)})
    public Response projectsFileopsMovePost(@ApiParam(value="The Id of the source project. The ID is encoded in Base64.", required=true) @FormParam(value="sourceProjectId") String sourceProjectId, @ApiParam(value="The Id of the file or folder to be copied. The ID is encoded in Base64.", required=true) @FormParam(value="sourceFileId") String sourceFileId, @ApiParam(value="the Id of the target project. The ID is encoded in Base64.", required=true) @FormParam(value="targetProjectId") String targetProjectId, @ApiParam(value="The Id of the folder in the target project. The target path *root* maps to the project root folder, otherwise, the ID is encoded in Base64.", required=true) @FormParam(value="targetFileId") String targetFileId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsFileopsMovePost(sourceProjectId, sourceFileId, targetProjectId, targetFileId, locale, securityContext);
    }

    @POST
    @Path(value="/fileops/rename")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Rename a file or a folder.", notes="This endpoint rename a file or a folder of a project.", response=ProjectFile.class, tags={"Project Files"})
    @ApiResponses(value={@ApiResponse(code=200, message="If the operation is completed with success.", response=ProjectFile.class), @ApiResponse(code=400, message="An invalid copy operation was attempted. For examples, if a mandatory parameter is empty or if one of the parameters *fileId*_/_*name* supplied is invalid.", response=ProjectFile.class), @ApiResponse(code=403, message="if the authenticated user is not authorized to read in the source project or to write in the target project.", response=ProjectFile.class), @ApiResponse(code=404, message="If the source or the target were not found.", response=ProjectFile.class)})
    public Response projectsFileopsRenamePost(@ApiParam(value="The Id of the project. The ID is encoded in Base64.", required=true) @FormParam(value="projectId") String projectId, @ApiParam(value="The Id of the file or folder to be renamed. The ID is encoded in Base64.", required=true) @FormParam(value="fileId") String fileId, @ApiParam(value="The new name.", required=true) @FormParam(value="name") String name, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsFileopsRenamePost(projectId, fileId, name, locale, securityContext);
    }

    @GET
    @Produces(value={"application/json;"})
    @ApiOperation(value="Get a list of projects accessible by the authenticated user.", notes="This endpoint return a list of projects. Requests accept filters to limit the projects in the result. The filters combine one or more parameters provided in the request.", response=Project.class, responseContainer="List", tags={"Projects"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=Project.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid *subset* supplied.", response=Project.class, responseContainer="List")})
    public Response projectsGet(@ApiParam(value="Filter projects which names contain the value passed through this parameter.") @QueryParam(value="name") String name, @ApiParam(value="Filter projects based on its ownership: *all* to return all projects that current user has access, *shared* to return the projects created by other users but shared with the current user and *my* to return all the projects owned by the current user. ", allowableValues="shared, my, all", defaultValue="all") @DefaultValue(value="all") @QueryParam(value="subset") String subset, @ApiParam(value="Filter projects that the authenticated user can edit.") @QueryParam(value="onlyEditable") Boolean onlyEditable, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsGet(name, subset, onlyEditable, locale, securityContext);
    }

    @GET
    @Path(value="/permissions")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Get a list of project ids accessible by the authenticated user.", notes="This endpoint return a list of project ids.", response=String.class, responseContainer="List", tags={"Projects"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=String.class, responseContainer="List")})
    public Response projectsPermissionsGet(@ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsPermissionsGet(locale, securityContext);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Create a new project.", notes="This endpoint create a new project. The name of the new project is mandatory. The response is the information about the new project created.", response=Project.class, responseContainer="List", tags={"Projects"})
    @ApiResponses(value={@ApiResponse(code=201, message="The new project was succesfully created.", response=Project.class, responseContainer="List"), @ApiResponse(code=400, message="If the name is empty or if the user already has a project with the same name", response=Project.class, responseContainer="List"), @ApiResponse(code=415, message="Unsupported Media Type", response=Project.class, responseContainer="List")})
    public Response projectsPost(@ApiParam(value="The name of the new project to be created. This parameter is mandatory.", required=true) @FormParam(value="name") String name, @ApiParam(value="The description of the new project.") @FormParam(value="description") String description, @ApiParam(value="The type of the new project") @FormParam(value="type") String type, @ApiParam(value="The visibility of the project.", allowableValues="private, public_ro, public_rw, selective") @FormParam(value="visibility") String visibility, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsPost(name, description, type, visibility, locale, securityContext);
    }

    @DELETE
    @Path(value="/{projectId}")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Deletes a project by ID.", notes="This endpoint permanently deletes a project by its ID. The currently authenticated user must own the project. The ID is encoded in Base64. If successful, this operation returns an empty response body.", response=void.class, tags={"Projects"})
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation", response=void.class), @ApiResponse(code=404, message="Project not found", response=void.class)})
    public Response projectsProjectIdDelete(@ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdDelete(projectId, locale, securityContext);
    }

    @DELETE
    @Path(value="/{projectId}/files/{fileId}")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Delete a file or a folder", notes="Delete a file or a folder indentified by the fileId parameter. If successful, this method returns an empty response body.", response=void.class, tags={"Project Files", "Projects"})
    @ApiResponses(value={@ApiResponse(code=204, message="If the file or folder was deleted with success.", response=void.class), @ApiResponse(code=400, message="If the file's location is invalid.", response=void.class), @ApiResponse(code=403, message="If the authenticated user is not authorized to delete files (or folders) in the project.", response=void.class), @ApiResponse(code=404, message="If the file or the project was not found", response=void.class)})
    public Response projectsProjectIdFilesFileIdDelete(@ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="The ID of a project file. The ID is the file path encoded in Base64. For example, the project file path \"dir/subdir/note.txt\" has the id \"ZGlyL3N1YmRpci9ub3RlLnR4dA==\".", required=true) @PathParam(value="fileId") String fileId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdFilesFileIdDelete(projectId, fileId, locale, securityContext);
    }

    @POST
    @Path(value="/{projectId}/files/{fileId}/folder")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Create a folder.", notes="", response=ProjectFile.class, tags={"Project Files", "Projects"})
    @ApiResponses(value={@ApiResponse(code=201, message="The new folder was succesfully created.", response=ProjectFile.class), @ApiResponse(code=400, message="If the name is empty or if the parent path is not a folder or if already exists another folder or file with the same name or if the supplied file's location is invalid.", response=ProjectFile.class), @ApiResponse(code=404, message="If the file or the project was not found", response=ProjectFile.class)})
    public Response projectsProjectIdFilesFileIdFolderPost(@ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="The ID of a project file. The ID is the file path encoded in Base64. For example, the project file path \"dir/subdir/note.txt\" has the id \"ZGlyL3N1YmRpci9ub3RlLnR4dA==\".", required=true) @PathParam(value="fileId") String fileId, @ApiParam(value="The name of the new folder to be created. This parameter is mandatory.", required=true) @FormParam(value="name") String name, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdFilesFileIdFolderPost(projectId, fileId, name, locale, securityContext);
    }

    @GET
    @Path(value="/{projectId}/files/{fileId}")
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Downloads a file.", notes="", response=void.class, tags={"Project Files", "Projects"})
    @ApiResponses(value={@ApiResponse(code=200, message="The specified file's contents", response=void.class), @ApiResponse(code=400, message="If it was supplied an invalid *projectId* or *fileId*.", response=void.class), @ApiResponse(code=403, message="If the user can`t view this file", response=void.class), @ApiResponse(code=404, message="If File Not Found.", response=void.class)})
    public Response projectsProjectIdFilesFileIdGet(@ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="The ID of a project file. The ID is the file path encoded in Base64. For example, the project file path \"dir/subdir/note.txt\" has the id \"ZGlyL3N1YmRpci9ub3RlLnR4dA==\".", required=true) @PathParam(value="fileId") String fileId, @ApiParam(value="if true, returns the file in zip format") @QueryParam(value="compress") Boolean compress, @ApiParam(value="The string charset response type parameter to download a file as text. Acceptable charsets are utf-8, iso-8859-1 and us-ascii. ") @QueryParam(value="charset") String charset, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdFilesFileIdGet(projectId, fileId, compress, charset, locale, securityContext);
    }

    @GET
    @Path(value="/{projectId}/files/{fileId}/link")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Returns a link directly to a file. This link bypasses the authentication webserver. Useful to downloading large files. This URL should not be used to display content directly in the browser. The link expires after 30 seconds. If need restart download, get again the link.", notes="", response=SuccessfulGetFileIdLink.class, tags={"Project Files", "Projects"})
    @ApiResponses(value={@ApiResponse(code=200, message="A url that serves the media directly without authentication.", response=SuccessfulGetFileIdLink.class), @ApiResponse(code=400, message="If the *fileId* is invalid.", response=SuccessfulGetFileIdLink.class), @ApiResponse(code=403, message="If user can`t view the project metadata.", response=SuccessfulGetFileIdLink.class), @ApiResponse(code=404, message="Project or File not found", response=SuccessfulGetFileIdLink.class)})
    public Response projectsProjectIdFilesFileIdLinkGet(@ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="The ID of a project file. The ID is the file path encoded in Base64. For example, the project file path \"dir/subdir/note.txt\" has the id \"ZGlyL3N1YmRpci9ub3RlLnR4dA==\".", required=true) @PathParam(value="fileId") String fileId, @ApiParam(value="if true, returns the file in zip format") @QueryParam(value="compress") Boolean compress, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdFilesFileIdLinkGet(projectId, fileId, compress, locale, securityContext);
    }

    @GET
    @Path(value="/{projectId}/files/{fileId}/metadata")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Retrieves file and folder metadata. To root folder, use the alias \"*root*\" for the fileId value.", notes="", response=FileMetadata.class, tags={"Project Files", "Projects"})
    @ApiResponses(value={@ApiResponse(code=200, message="successful operation", response=FileMetadata.class), @ApiResponse(code=400, message="If the *fileId* is invalid.", response=FileMetadata.class), @ApiResponse(code=403, message="If user can`t view the project metadata.", response=FileMetadata.class), @ApiResponse(code=404, message="Project or File not found", response=FileMetadata.class)})
    public Response projectsProjectIdFilesFileIdMetadataGet(@ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="The ID of a project file. The ID is the file path encoded in Base64. For example, the project file path \"dir/subdir/note.txt\" has the id \"ZGlyL3N1YmRpci9ub3RlLnR4dA==\".", required=true) @PathParam(value="fileId") String fileId, @ApiParam(value="Determines if hidden files should be listed or not. It is not a mandatory parameter and the default value is false.") @QueryParam(value="showHiddenFiles") Boolean showHiddenFiles, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdFilesFileIdMetadataGet(projectId, fileId, showHiddenFiles, locale, securityContext);
    }

    @GET
    @Path(value="/{projectId}/files")
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Downloads multiple file", notes="", response=void.class, tags={"Project Files", "Projects"})
    @ApiResponses(value={@ApiResponse(code=200, message="The specified file's contents", response=void.class), @ApiResponse(code=400, message="invalid *projectId* supplied", response=void.class), @ApiResponse(code=403, message="if the user can`t view this file", response=void.class), @ApiResponse(code=404, message="If some file Not Found.", response=void.class)})
    public Response projectsProjectIdFilesGet(@ApiParam(value="files's ids List to be downloaded together was ZIP.", required=true) @QueryParam(value="files") List<String> files, @ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="ZIP file name. Default value is \"Archive\"") @QueryParam(value="zipName") String zipName, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdFilesGet(files, projectId, zipName, locale, securityContext);
    }

    @GET
    @Path(value="/{projectId}/files/link")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Returns a link directly to download multiple files. Because of URL size limitation, it's appropriate download multiple files by POST type operation.", notes="Returns a link directly do download multiple files. This link bypasses the authentication webserver. Useful to downloading large content. This URL should not be used to display content directly in the browser. The link expires after 30 seconds. If need restart download, get again the link. **Because of URL size limitation, it's appropriate download multiple files by POST type operation.** ", response=SuccessfulGetFilesLink.class, tags={"Project Files", "Projects"})
    @ApiResponses(value={@ApiResponse(code=200, message="A url that serves the media directly without authentication.", response=SuccessfulGetFilesLink.class), @ApiResponse(code=400, message="Empty files parameter or if files parameter contains only empty strings", response=SuccessfulGetFilesLink.class), @ApiResponse(code=403, message="if user can`t view the project metadata.", response=SuccessfulGetFilesLink.class), @ApiResponse(code=404, message="Project or File not found", response=SuccessfulGetFilesLink.class)})
    public Response projectsProjectIdFilesLinkGet(@ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="files's ids List to be downloaded together was ZIP.", required=true) @QueryParam(value="files") List<String> files, @ApiParam(value="ZIP file name. Default value is \"Archive\"") @QueryParam(value="zipName") String zipName, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdFilesLinkGet(projectId, files, zipName, locale, securityContext);
    }

    @POST
    @Path(value="/{projectId}/files/link")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Returns a link directly to download multiple files.", notes="Returns a link directly do download multiple files. This link bypasses the authentication webserver. Useful to downloading large content. This URL should not be used to display content directly in the browser. The link expires after 30 seconds. If need restart download, get again the link.", response=SuccessfulGetFilesLink.class, tags={"Project Files", "Projects"})
    @ApiResponses(value={@ApiResponse(code=200, message="A url that serves the media directly without authentication.", response=SuccessfulGetFilesLink.class), @ApiResponse(code=400, message="Empty files parameter or if files parameter contains only empty strings", response=SuccessfulGetFilesLink.class), @ApiResponse(code=403, message="if user can`t view the project metadata.", response=SuccessfulGetFilesLink.class), @ApiResponse(code=404, message="Project or File not found", response=SuccessfulGetFilesLink.class)})
    public Response projectsProjectIdFilesLinkPost(@ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="files's ids List to be downloaded together was ZIP.", required=true) @FormParam(value="files") List<String> files, @ApiParam(value="ZIP file name. Default value is \"Archive\"") @QueryParam(value="zipName") String zipName, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdFilesLinkPost(projectId, files, zipName, locale, securityContext);
    }

    @POST
    @Path(value="/{projectId}/files/{parentId}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Upload a file.  If exist a file with de same name, the content will be overriden.", notes="If you use \"resumable\" file upload type, the typical usage:<br><br> 1. Send a POST request with the first chunck of the file without setting uploadId, and receive and an uploadId and fileName in return. <br/> 2. Repeatedly POST subsequent chunks using the uploadId.</br> 3. Is not necessary do anything after the last chunk post. <br/><br/> If a resumable upload stop without complete, a broken file is stored on the server. To resume, is necessary pass the uploadId, otherwise a new file is created.<br/> To stop a upload session, use a delete service.  ", response=SuccessfulUploadFile.class, tags={"Project Files", "Projects"})
    @ApiResponses(value={@ApiResponse(code=200, message="created", response=SuccessfulUploadFile.class), @ApiResponse(code=400, message="Project or file not found", response=SuccessfulUploadFile.class), @ApiResponse(code=403, message="If the user can`t edit or view this file.", response=SuccessfulUploadFile.class)})
    public Response projectsProjectIdFilesParentIdPost(@ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="The ID of a parent folder. The ID is the folder path encoded in Base64 or \"root\". For example, the folder path \"dir/subdir\" has the id \"ZGlyL3N1YmRpcg==\".", required=true) @PathParam(value="parentId") String parentId, @FormDataParam(value="file") InputStream fileInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @ApiParam(value="\"multipart\" for quick transfer of smaller files.<br/> \"resumable\" for reliable transfer, especially important with larger files. With this method, you use a session initiating request. This is a good strategy to use for most applications, since it also works for smaller files at the cost of one additional HTTP request per upload.  ", required=true) @FormDataParam(value="uploadType") String uploadType, @ApiParam(value="The unique ID of the in-progress upload on the server. If left blank, the server will create a new upload session. It is only necessary and mandatory for resumable upload.") @FormDataParam(value="uploadId") String uploadId, @ApiParam(value="Determine where to start the resumed upload. It is only necessary and mandatory for resumable upload. ") @FormDataParam(value="rangeStart") Long rangeStart, @ApiParam(value="Determine where to end the resumed upload. It is only necessary and mandatory for resumable upload. ") @FormDataParam(value="rangeEnd") Long rangeEnd, @ApiParam(value="The total file size. It is only necessary and mandatory for resumable upload. ") @FormDataParam(value="totalSize") Long totalSize, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for upload service message responses.") @FormDataParam(value="locale") String locale, @ApiParam(value="The string charset to download files. The parameter is only used with 'multipart' upload type. <br /> Values can be US-ASCII, ISO-8859-1 and UTF-8. ") @FormDataParam(value="charset") String charset, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdFilesParentIdPost(projectId, parentId, fileInputStream, fileDetail, uploadType, uploadId, rangeStart, rangeEnd, totalSize, locale, charset, securityContext);
    }

    @GET
    @Path(value="/{projectId}")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Find a project by its ID", notes="This endpoint returns a project by its ID. The ID is encoded in Base64.", response=Project.class, tags={"Projects"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=Project.class), @ApiResponse(code=404, message="Project not found.", response=Project.class)})
    public Response projectsProjectIdGet(@ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdGet(projectId, locale, securityContext);
    }

    @GET
    @Path(value="/{projectId}/members")
    @Produces(value={"application/json;"})
    @ApiOperation(value="List the team members of a project", notes="", response=TeamMember.class, responseContainer="List", tags={"Projects", "Project Members"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=TeamMember.class, responseContainer="List"), @ApiResponse(code=403, message="if the user can`t access this project", response=TeamMember.class, responseContainer="List")})
    public Response projectsProjectIdMembersGet(@ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdMembersGet(projectId, locale, securityContext);
    }

    @DELETE
    @Path(value="/{projectId}/members/{userId}")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Remove a member from a project team", notes="This endpoint revokes a team membership for a user who is currently a project member. This method is idempotent and can be called multiple times with the same parameters. Revoking team membership for a user who is not currently a team member is considered success. If successful this method returns an empty response body.", response=void.class, tags={"Projects", "Project Members"})
    @ApiResponses(value={@ApiResponse(code=204, message="successful operation", response=void.class), @ApiResponse(code=400, message="if the user provided in the userId parameter does not exist.", response=void.class), @ApiResponse(code=403, message="if the authenticated user is not authorized to do this operation", response=void.class)})
    public Response projectsProjectIdMembersUserIdDelete(@ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="The ID of an user.", required=true) @PathParam(value="userId") String userId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdMembersUserIdDelete(projectId, userId, locale, securityContext);
    }

    @GET
    @Path(value="/{projectId}/members/{userId}")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Get the information about a member of a project team.", notes="This endpoint responses the access level of an user that is a project member.", response=TeamMember.class, tags={"Projects", "Project Members"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=TeamMember.class), @ApiResponse(code=400, message="if the user provided in the userId parameter does not exist.", response=TeamMember.class), @ApiResponse(code=403, message="if the authenticated user is not authorized to do this operation", response=TeamMember.class), @ApiResponse(code=404, message="the user is not a project member", response=TeamMember.class)})
    public Response projectsProjectIdMembersUserIdGet(@ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="The ID of an user.", required=true) @PathParam(value="userId") String userId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdMembersUserIdGet(projectId, userId, locale, securityContext);
    }

    @PUT
    @Path(value="/{projectId}/members/{userId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Updates the access level of an user as a project team member. If the user is not part of the project members, he/she is added as the result of the operation.", notes="This endpoit changes the access level of an user that is a project member. On success, method returns a response body with the access level of the user provided in the userId parameter. This method is idempotent and can be called multiple times with the same parameters.", response=TeamMember.class, tags={"Projects", "Project Members"})
    @ApiResponses(value={@ApiResponse(code=200, message="successful operation", response=TeamMember.class), @ApiResponse(code=400, message="if the user provided in the userId parameter does not exist or if the user is the project owner.", response=TeamMember.class), @ApiResponse(code=403, message="if the authenticated user is not authorized to do this operation", response=TeamMember.class)})
    public Response projectsProjectIdMembersUserIdPut(@ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="The ID of an user.", required=true) @PathParam(value="userId") String userId, @ApiParam(value="If false, the user can only read the project. If true, the user can read and write the project content. The default is false.", defaultValue="false") @DefaultValue(value="false") @FormParam(value="editable") Boolean editable, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @FormParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdMembersUserIdPut(projectId, userId, editable, locale, securityContext);
    }

    @PUT
    @Path(value="/{projectId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Update an existing project", notes="This endpoint allows a project update by the authenticated user. The ID is encoded in Base64. On success, method returns 200 with the updated project.", response=Project.class, tags={"Projects"})
    @ApiResponses(value={@ApiResponse(code=200, message="Updated", response=Project.class), @ApiResponse(code=400, message="if the requisition does not contain at least one of the parameters description or visbility; or if the visibility parameter is not valid. ", response=Project.class), @ApiResponse(code=403, message="if the authenticated user is not authorized to update this project.", response=Project.class), @ApiResponse(code=404, message="if the project with the ID provided was not found.", response=Project.class)})
    public Response projectsProjectIdPut(@ApiParam(value="The ID of a project.", required=true) @PathParam(value="projectId") String projectId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @ApiParam(value="The description of the project.") @FormParam(value="description") String description, @ApiParam(value="") @FormParam(value="type") String type, @ApiParam(value="The visibility of the project.", allowableValues="private, public_ro, public_rw, selective") @FormParam(value="visibility") String visibility, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.projectsProjectIdPut(projectId, locale, description, type, visibility, securityContext);
    }
}

