/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.project.v2;

import ibase.rest.model.project.v2.TeamMember;
import ibase.rest.model.project.v2.User;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Project {
    private String id = null;
    private String name = null;
    private String description = null;
    private User owner = null;
    private Boolean editable = null;
    private Boolean isOwner = null;
    private Long modified = null;
    private Long created = null;
    private String type = null;
    private VisibilityEnum visibility = null;
    private List<TeamMember> members = new ArrayList<TeamMember>();

    public Project id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Project name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Project description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Project owner(User owner) {
        this.owner = owner;
        return this;
    }

    @ApiModelProperty(value="")
    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public Project editable(Boolean editable) {
        this.editable = editable;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public Project isOwner(Boolean isOwner) {
        this.isOwner = isOwner;
        return this;
    }

    @ApiModelProperty(value="if the authenticated user is the project owner")
    public Boolean getIsOwner() {
        return this.isOwner;
    }

    public void setIsOwner(Boolean isOwner) {
        this.isOwner = isOwner;
    }

    public Project modified(Long modified) {
        this.modified = modified;
        return this;
    }

    @ApiModelProperty(value="last modification timestamp of the project")
    public Long getModified() {
        return this.modified;
    }

    public void setModified(Long modified) {
        this.modified = modified;
    }

    public Project created(Long created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(value="created timestamp of the project")
    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Project type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="the type of the project")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Project visibility(VisibilityEnum visibility) {
        this.visibility = visibility;
        return this;
    }

    @ApiModelProperty(value="")
    public VisibilityEnum getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilityEnum visibility) {
        this.visibility = visibility;
    }

    public Project members(List<TeamMember> members) {
        this.members = members;
        return this;
    }

    public Project addMembersItem(TeamMember membersItem) {
        this.members.add(membersItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<TeamMember> getMembers() {
        return this.members;
    }

    public void setMembers(List<TeamMember> members) {
        this.members = members;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project)o;
        return Objects.equals(this.id, project.id) && Objects.equals(this.name, project.name) && Objects.equals(this.description, project.description) && Objects.equals(this.owner, project.owner) && Objects.equals(this.editable, project.editable) && Objects.equals(this.isOwner, project.isOwner) && Objects.equals(this.modified, project.modified) && Objects.equals(this.created, project.created) && Objects.equals(this.type, project.type) && Objects.equals((Object)this.visibility, (Object)project.visibility) && Objects.equals(this.members, project.members);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.owner, this.editable, this.isOwner, this.modified, this.created, this.type, this.visibility, this.members});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Project {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    editable: ").append(this.toIndentedString(this.editable)).append("\n");
        sb.append("    isOwner: ").append(this.toIndentedString(this.isOwner)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString((Object)this.visibility)).append("\n");
        sb.append("    members: ").append(this.toIndentedString(this.members)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum VisibilityEnum {
        PRIVATE("private"),
        PUBLIC_RO("public_ro"),
        PUBLIC_RW("public_rw"),
        SELECTIVE("selective");

        private String value;

        private VisibilityEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

