package tecgraf.javautils.concurrent.locks;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Log das aes do LockManager e classes relacionadas
 * 
 * 
 * @author Tecgraf
 */
class LockLogger {

  /**
   * Instncia - Singleton
   */
  private static LockLogger instance;
  static {
    instance = new LockLogger();
  }

  /**
   * Log esttico
   */
  private Logger theLogger = null;

  /**
   * Construtor privado
   */
  private LockLogger() {

  }

  /**
   * Retorna a instncia singleton da classe
   * 
   * @return a instncia singleton da classe
   */
  static LockLogger getInstance() {
    return instance;
  }

  /**
   * Define o log utilizado
   * 
   * @param logger
   */
  void setLogger(Logger logger) {
    theLogger = logger;
  }

  /**
   * Recupera o logger utilizado
   * 
   * @return o logger utilizado
   */
  public Logger getLogger() {
    return theLogger;
  }

  /**
   * Grava mensagem de log
   * 
   * @param level nvel da informao de log
   * @param msg mensagem de log
   */
  private void logMessage(Level level, String msg) {
    //Atributo local ao mtodo para evitar problemas de NullPointer
    Logger logger = null;
    //Deve ser sincronizado pois o usurio pode atribuir null ao logger
    synchronized (this) {
      logger = theLogger;
    }
    //Grava a mensagem se existe um log registrado
    if (logger != null) {
      logger.log(level, msg);
    }
    else {
      //Caso no haja log registrado, escreve mensagem no output padro
      System.out.println(level.toString() + ": " + msg);
    }
  }

  /**
   * 
   * @param msg
   */
  void config(String msg) {
    this.logMessage(Level.CONFIG, msg);
  }

  /**
   * 
   * @param msg
   */
  void warning(String msg) {
    this.logMessage(Level.WARNING, msg);
  }

  /**
   * 
   * @param msg
   */
  void severe(String msg) {
    this.logMessage(Level.SEVERE, msg);
  }

  /**
   * 
   * @param msg
   */
  void info(String msg) {
    this.logMessage(Level.INFO, msg);
  }

  /**
   * 
   * @param msg
   */
  void fine(String msg) {
    this.logMessage(Level.FINE, msg);
  }

  /**
   * 
   * @param msg
   */
  void finer(String msg) {
    this.logMessage(Level.FINER, msg);
  }

  /**
   * 
   * @param msg
   */
  void finest(String msg) {
    this.logMessage(Level.FINEST, msg);
  }

}
