/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.configurationmanager;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import tecgraf.javautils.configurationmanager.IllegalFormatException;
import tecgraf.javautils.configurationmanager.Logger;
import tecgraf.javautils.configurationmanager.MissingPropertyException;

public class Configuration {
    private static final String PROPERTY_NAME_FORMAT_SUFFIX = ".{0}";
    private static final Map<Class<?>, Map<String, String>> cache = new HashMap();
    private Map<String, String> propertiesMap;
    private Class<?> ownerClass;
    private Configuration parent;
    private Set<Configuration> children;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Configuration(Class<?> ownerClass, Configuration parent) {
        if (ownerClass == null) {
            throw new IllegalArgumentException("A classe dona da configura\u00e7\u00e3o n\u00e3o pode ser nula.");
        }
        this.ownerClass = ownerClass;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.propertiesMap = new HashMap<String, String>();
        Map<Class<?>, Map<String, String>> map = cache;
        synchronized (map) {
            cache.put(ownerClass, new HashMap());
        }
        this.log("Configura\u00e7\u00e3o criada");
    }

    public Set<String> getPropertyKeys() {
        HashSet<String> propertyKeys = new HashSet<String>();
        if (this.parent != null) {
            propertyKeys.addAll(this.parent.getPropertyKeys());
        }
        propertyKeys.addAll(this.propertiesMap.keySet());
        return Collections.unmodifiableSet(propertyKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOptionalProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("O nome da propriedade n\u00e3o pode ser nulo.");
        }
        this.log("Tentando obter o valor da propriedade %s.", name);
        Map<Class<?>, Map<String, String>> map = cache;
        synchronized (map) {
            Map<String, String> propsCache = cache.get(this.ownerClass);
            if (propsCache.containsKey(name)) {
                return propsCache.get(name);
            }
        }
        String value = this.propertiesMap.get(name);
        if (value == null && this.parent != null) {
            this.log("Verificando o valor da propriedade %s na configura\u00e7\u00e3o-pai.", name);
            value = this.parent.getOptionalProperty(name);
        }
        Map<Class<?>, Map<String, String>> map2 = cache;
        synchronized (map2) {
            cache.get(this.ownerClass).put(name, value);
        }
        if (value == null) {
            this.log("O valor da propriedade %s n\u00e3o foi encontrado.", name);
        } else {
            this.log("Valor da propriedade %s encontrado. Valor = %s.", name, value);
        }
        return value;
    }

    public String getOptionalProperty(String name, String defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException("O nome da propriedade n\u00e3o pode ser nulo.");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("O valor default n\u00e3o pode ser nulo.");
        }
        this.log("Tentando obter o valor da propriedade %s (valor-padr\u00e3o %s)", name, defaultValue);
        String value = this.getOptionalProperty(name);
        if (value == null) {
            this.log("O valor da propriedade %s n\u00e3o foi encontrado.\nUtilizando valor-padr\u00e3o (%s)", name, defaultValue);
            return defaultValue;
        }
        return value;
    }

    public String getMandatoryProperty(String name) throws MissingPropertyException {
        if (name == null) {
            throw new IllegalArgumentException("O nome da propriedade n\u00e3o pode ser nulo.");
        }
        String value = this.getOptionalProperty(name);
        if (value == null) {
            throw new MissingPropertyException(this.ownerClass, name);
        }
        return value;
    }

    public Boolean getOptionalBooleanProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("O nome da propriedade n\u00e3o pode ser nulo.");
        }
        String value = this.getOptionalProperty(name);
        if (value == null) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    public Boolean getOptionalBooleanProperty(String name, boolean defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException("O nome da propriedade n\u00e3o pode ser nulo.");
        }
        String value = this.getOptionalProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public Boolean getMandatoryBooleanProperty(String name) throws MissingPropertyException {
        if (name == null) {
            throw new IllegalArgumentException("O nome da propriedade n\u00e3o pode ser nulo.");
        }
        String value = this.getOptionalProperty(name);
        if (value == null) {
            throw new MissingPropertyException(this.ownerClass, name);
        }
        return Boolean.valueOf(value);
    }

    public Long getOptionalLongProperty(String name, long defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException("O nome da propriedade n\u00e3o pode ser nulo.");
        }
        String value = this.getOptionalProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return Long.valueOf(value);
    }

    public Integer getOptionalIntegerProperty(String name, int defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException("O nome da propriedade n\u00e3o pode ser nulo.");
        }
        String value = this.getOptionalProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    public <T> Class<T> getOptionalClassProperty(String name) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("O nome da propriedade n\u00e3o pode ser nulo.");
        }
        String value = this.getOptionalProperty(name);
        if (value == null) {
            return null;
        }
        return Class.forName(value);
    }

    public <T> Class<T> getOptionalClassProperty(String name, Class<T> defaultClass) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("O nome da propriedade n\u00e3o pode ser nulo.");
        }
        if (defaultClass == null) {
            throw new IllegalArgumentException("A classe default n\u00e3o pode ser nula.");
        }
        Class<T> clazz = this.getOptionalClassProperty(name);
        if (clazz == null) {
            return defaultClass;
        }
        return clazz;
    }

    public <T> Class<T> getMandatoryClassProperty(String name) throws MissingPropertyException, ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("O nome da propriedade n\u00e3o pode ser nulo.");
        }
        Class<T> clazz = this.getOptionalClassProperty(name);
        if (clazz == null) {
            throw new MissingPropertyException(this.ownerClass, name);
        }
        return clazz;
    }

    public List<String> getOptionalListProperty(String name) {
        String value;
        if (name == null) {
            throw new IllegalArgumentException("O padr\u00e3o do nome da propriedade n\u00e3o pode ser nulo.");
        }
        String pattern = name + PROPERTY_NAME_FORMAT_SUFFIX;
        LinkedList<String> list = new LinkedList<String>();
        int i = 1;
        while ((value = this.getOptionalProperty(MessageFormat.format(pattern, i))) != null) {
            list.add(value);
            ++i;
        }
        return Collections.unmodifiableList(list);
    }

    public List<String> getMandatoryListProperty(String name) throws MissingPropertyException {
        String value;
        if (name == null) {
            throw new IllegalArgumentException("O padr\u00e3o do nome da propriedade n\u00e3o pode ser nulo.");
        }
        String pattern = name + PROPERTY_NAME_FORMAT_SUFFIX;
        LinkedList<String> list = new LinkedList<String>();
        int i = 1;
        while ((value = this.getOptionalProperty(MessageFormat.format(pattern, i))) != null) {
            list.add(value);
            ++i;
        }
        if (list.isEmpty()) {
            throw new MissingPropertyException(this.ownerClass, name);
        }
        return Collections.unmodifiableList(list);
    }

    public Locale getOptionalLocaleProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("O nome da propriedade n\u00e3o pode ser nulo.");
        }
        String value = this.getOptionalProperty(name);
        if (value == null) {
            return null;
        }
        return this.parseLocale(value);
    }

    public Locale getOptionalLocaleProperty(String name, Locale defaultLocale) {
        if (name == null) {
            throw new IllegalArgumentException("O nome da propriedade n\u00e3o pode ser nulo.");
        }
        if (defaultLocale == null) {
            throw new IllegalArgumentException("A locale default n\u00e3o pode ser nula.");
        }
        Locale locale = this.getOptionalLocaleProperty(name);
        if (locale == null) {
            return defaultLocale;
        }
        return locale;
    }

    public Locale getMandatoryLocaleProperty(String name) throws MissingPropertyException {
        if (name == null) {
            throw new IllegalArgumentException("O nome da propriedade n\u00e3o pode ser nulo.");
        }
        Locale locale = this.getOptionalLocaleProperty(name);
        if (locale == null) {
            throw new MissingPropertyException(this.ownerClass, name);
        }
        return locale;
    }

    public List<Locale> getOptionalLocaleListProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("O padr\u00e3o do nome da propriedade n\u00e3o pode ser nulo.");
        }
        List<String> propertyList = this.getOptionalListProperty(name);
        ArrayList<Locale> localeList = new ArrayList<Locale>(propertyList.size());
        for (String property : propertyList) {
            Locale locale = this.parseLocale(property);
            if (locale == null) continue;
            localeList.add(locale);
        }
        return Collections.unmodifiableList(localeList);
    }

    public List<Locale> getMandatoryLocaleListProperty(String name) throws MissingPropertyException {
        if (name == null) {
            throw new IllegalArgumentException("O padr\u00e3o do nome da propriedade n\u00e3o pode ser nulo.");
        }
        List<String> propertyList = this.getMandatoryListProperty(name);
        ArrayList<Locale> localeList = new ArrayList<Locale>(propertyList.size());
        for (String property : propertyList) {
            Locale locale = this.parseLocale(property);
            if (locale == null) continue;
            localeList.add(locale);
        }
        if (localeList.isEmpty()) {
            throw new MissingPropertyException(this.ownerClass, name);
        }
        return Collections.unmodifiableList(localeList);
    }

    public <E extends Enum<E>> E getOptionalEnumerationProperty(String name, Class<E> enumerationClass, E defaultValue) throws IllegalFormatException {
        String valueName = this.getOptionalProperty(name);
        if (valueName == null) {
            return defaultValue;
        }
        for (Enum value : (Enum[])enumerationClass.getEnumConstants()) {
            if (!valueName.equals(value.name())) continue;
            return (E)value;
        }
        String details = String.format("Valores v\u00e1lidos:\n", new Object[0]);
        for (Enum value : (Enum[])enumerationClass.getEnumConstants()) {
            details = details + value.name() + "\n";
        }
        throw new IllegalFormatException(this.ownerClass, name, valueName, details);
    }

    public String toString() {
        return String.format("configura\u00e7\u00e3o : classe %s (pai : %s)", this.ownerClass.getName(), this.parent);
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        Configuration other = (Configuration)obj;
        return this.ownerClass.equals(other.ownerClass);
    }

    public int hashCode() {
        return this.ownerClass.hashCode();
    }

    void merge(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("A cole\u00e7\u00e3o de propriedades n\u00e3o pode ser nula.");
        }
        this.log("Realizando merge");
        this.log("Propriedades antes do merge: %s", this.propertiesMap);
        this.log("Novas propriedades: %s", properties);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.propertiesMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.log("Propriedades depois do merge: %s", this.propertiesMap);
        this.clearCacheDownwards();
    }

    private void log(String message, Object ... args) {
        Logger.getInstance().log("%s : %s", this, String.format(message, args));
    }

    private void log(String message) {
        Logger.getInstance().log("%s : %s", this, message);
    }

    private void addChild(Configuration child) {
        if (this.children == null) {
            this.children = new HashSet<Configuration>();
        }
        this.children.add(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCacheDownwards() {
        Map<Class<?>, Map<String, String>> map = cache;
        synchronized (map) {
            cache.get(this.ownerClass).clear();
            if (this.children != null) {
                Iterator<Configuration> iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    iterator.next().clearCacheDownwards();
                }
            }
        }
    }

    private Locale parseLocale(String localeStr) {
        if (localeStr == null || localeStr.length() == 0) {
            return null;
        }
        String[] tokens = localeStr.split("_", 3);
        switch (tokens.length) {
            case 0: {
                return null;
            }
            case 1: {
                return new Locale(tokens[0]);
            }
            case 2: {
                return new Locale(tokens[0], tokens[1]);
            }
            case 3: {
                return new Locale(tokens[0], tokens[1], tokens[2]);
            }
        }
        return null;
    }
}

