/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.configurationmanager;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.configurationmanager.Logger;

public final class ConfigurationManager {
    private static final char RESOURCE_NAME_SEPARATOR = '/';
    private static final char PACKAGE_SEPARATOR = '.';
    private static final String CONFIGURATION_FILE_EXTENSION = ".properties";
    private static final String CONFIGURATION_PREFIX = "/conf/";
    private static final String DEFAULT_EXTENSION_PREFIX = "/conf/ext/";
    private static final String MODE_PROPERTY_NAME = "mode";
    private static final Logger.Mode MODE_PROPERTY_VALUE = Logger.Mode.SILENT;
    private static ConfigurationManager instance;
    static Map<String, String> cache;
    private static final List<String> CLASS_PREFIXES_BLACKLIST;
    private Map<Class<?>, Configuration> configurationMap = new HashMap();
    private String extensionPrefix;

    private ConfigurationManager() {
        this(DEFAULT_EXTENSION_PREFIX);
    }

    private ConfigurationManager(String extensionPrefix) {
        this.extensionPrefix = extensionPrefix;
        try {
            Configuration configuration = this.getConfiguration(ConfigurationManager.class);
            Logger.Mode mode = configuration.getOptionalEnumerationProperty(MODE_PROPERTY_NAME, Logger.Mode.class, MODE_PROPERTY_VALUE);
            Logger.getInstance().setMode(mode);
        }
        catch (ConfigurationManagerException e) {
            this.log(e, "Erro ao tentar carregar as propriedades do ConfigurationManager.", new Object[0]);
        }
        this.log("Modo: %s.", new Object[]{Logger.getInstance().getMode()});
        this.log("Prefixo de extens\u00e3o: %s.", extensionPrefix);
    }

    public Configuration getConfiguration(Class<?> ownerClass) throws ConfigurationManagerException {
        if (ownerClass == null) {
            throw new IllegalArgumentException("A classe dona da configura\u00e7\u00e3o n\u00e3o pode ser nula.");
        }
        this.log("Solicitada a configura\u00e7\u00e3o da classe %s.", ownerClass.getName());
        Configuration currentConfiguration = this.configurationMap.get(ownerClass);
        if (currentConfiguration != null) {
            return currentConfiguration;
        }
        Stack classStack = new Stack();
        for (Class<?> currentClass = ownerClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            String className = currentClass.getName();
            boolean skip = false;
            for (String forbiddenClass : CLASS_PREFIXES_BLACKLIST) {
                if (!className.startsWith(forbiddenClass)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            classStack.push(currentClass);
        }
        Configuration previousConfiguration = null;
        while (!classStack.isEmpty()) {
            Class currentClass = (Class)classStack.pop();
            this.log("Tentando obter a configura\u00e7\u00e3o da classe %s para atender a solicita\u00e7\u00e3o de configura\u00e7\u00e3o para a classe %s.", currentClass.getName(), ownerClass.getName());
            currentConfiguration = this.configurationMap.get(currentClass);
            if (currentConfiguration == null) {
                Properties extensionProperties;
                this.log("A configura\u00e7\u00e3o da classe %s n\u00e3o est\u00e1 no cache.", currentClass.getName());
                currentConfiguration = new Configuration(currentClass, previousConfiguration);
                Properties configurationProperties = this.loadProperties(currentClass, CONFIGURATION_PREFIX);
                if (configurationProperties != null) {
                    this.log("Realizando o merge da configura\u00e7\u00e3o da classe %s utilizando o prefixo %s.", currentClass.getName(), CONFIGURATION_PREFIX);
                    currentConfiguration.merge(configurationProperties);
                    this.log("O merge da configura\u00e7\u00e3o da classe %s utilizando o prefixo %s foi feito.", currentClass.getName(), CONFIGURATION_PREFIX);
                }
                if ((extensionProperties = this.loadProperties(currentClass, this.extensionPrefix)) != null) {
                    this.log("Realizando o merge da configura\u00e7\u00e3o da classe %s utilizando o prefixo %s.", currentClass.getName(), this.extensionPrefix);
                    currentConfiguration.merge(extensionProperties);
                    this.log("O merge da configura\u00e7\u00e3o da classe %s utilizando o prefixo %s foi feito.", currentClass.getName(), this.extensionPrefix);
                }
                this.configurationMap.put(currentClass, currentConfiguration);
                this.log("A configura\u00e7\u00e3o da classe %s adicionada ao cache.", currentClass.getName());
            }
            previousConfiguration = currentConfiguration;
        }
        if (currentConfiguration != null) {
            this.log("A configura\u00e7\u00e3o da classe %s foi encontrada.", ownerClass.getName());
        } else {
            this.log("A configura\u00e7\u00e3o da classe %s n\u00e3o foi encontrada.", ownerClass.getName());
        }
        return currentConfiguration;
    }

    public static void createInstance() {
        if (instance != null) {
            throw new IllegalStateException("J\u00e1 existe uma inst\u00e2ncia criada.");
        }
        instance = new ConfigurationManager();
    }

    public static void createInstance(String extensionPrefix) {
        if (instance != null) {
            throw new IllegalStateException("J\u00e1 existe uma inst\u00e2ncia criada.");
        }
        instance = new ConfigurationManager(extensionPrefix);
    }

    public static ConfigurationManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("N\u00e3o existe nenhuma inst\u00e2ncia criada.");
        }
        return instance;
    }

    private void log(Throwable throwable, String message, Object ... args) {
        Logger.getInstance().log(throwable, message, args);
    }

    private void log(String message, Object ... args) {
        Logger.getInstance().log(message, args);
    }

    private Properties loadProperties(Class<?> ownerClass, String prefix) throws ConfigurationManagerException {
        this.log("Carregando as propriedades da classe %s utilizando o prefixo %s.", ownerClass.getName(), prefix);
        StringBuilder strBuilder = new StringBuilder(prefix);
        if (prefix.charAt(prefix.length() - 1) != '/') {
            strBuilder.append('/');
        }
        strBuilder.append(ownerClass.getName().replace('.', '/'));
        strBuilder.append(CONFIGURATION_FILE_EXTENSION);
        String propertiesFile = strBuilder.toString();
        this.log("Verificando se o arquivo %s pode ser encontrado.", propertiesFile);
        InputStream inputStream = this.getInputStreamForResource(propertiesFile);
        if (inputStream == null) {
            return null;
        }
        this.log("Carregandos as propriedades de %s.", propertiesFile);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            ConfigurationManagerException exception = new ConfigurationManagerException(e, "Erro ao carregar as propriedades de {0}.", propertiesFile);
            throw exception;
        }
        this.log("As propriedades do arquivo %s foram carregadas.", propertiesFile);
        StringBuilder message = new StringBuilder();
        message.append(String.format("A seguir uma listagem de todas as propriedades do arquivo %s. ", propertiesFile));
        message.append("Cada propriedade ser\u00e1 exibida com seguinte formato:\n");
        message.append("[chave]=[valor]\n");
        message.append("Os colchetes delimitam a chave e o valor. ");
        message.append("A chave e o valor s\u00e3o separados por '='.\n");
        for (Object key : properties.keySet()) {
            Object value = properties.get(key);
            message.append(String.format("[%s]=[%s]\n", key, value));
        }
        this.log(message.toString(), new Object[0]);
        this.log("As propriedades da classe %s utilizando o prefixo %s foram carregadas.", ownerClass.getName(), prefix);
        return properties;
    }

    private InputStream getInputStreamForResource(String propertiesFile) {
        if (propertiesFile.matches("^(https?|file|ftp):.*")) {
            try {
                return new URL(propertiesFile).openStream();
            }
            catch (Exception e) {
                this.log(e, "Erro acessando a URL {0}", propertiesFile);
                return null;
            }
        }
        InputStream inputStream = ConfigurationManager.class.getResourceAsStream(propertiesFile);
        if (inputStream == null) {
            this.log("O arquivo %s n\u00e3o foi encontrado.", propertiesFile);
        }
        return inputStream;
    }

    static {
        CLASS_PREFIXES_BLACKLIST = Arrays.asList("java.", "javax.", "com.", "org.");
    }
}

