/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.configurationmanager;

import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    private static Logger instance;
    private Mode mode;

    private Logger() {
        this.setMode(Mode.SILENT);
    }

    public static Logger getInstance() {
        if (instance == null) {
            instance = new Logger();
        }
        return instance;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void log(String message, Object ... args) {
        if (this.mode.equals((Object)Mode.VERBOSE)) {
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd - HH:mm:ss");
            System.err.printf("LOG: [%s] %s\n", dateFormat.format(date), String.format(message, args));
        }
    }

    public void log(Throwable throwable, String message, Object ... args) {
        if (this.mode.equals((Object)Mode.VERBOSE)) {
            this.log(message, args);
            for (Throwable cause = throwable; cause != null && cause != cause.getCause(); cause = cause.getCause()) {
                cause.printStackTrace();
            }
        }
    }

    void setMode(Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode n\u00e3o pode ser nulo.");
        }
        this.mode = mode;
    }

    public static enum Mode {
        SILENT,
        VERBOSE;

    }
}

