package tecgraf.javautils.excel.v1.poi;

import org.apache.poi.hssf.util.HSSFColor;

import tecgraf.javautils.excel.v1.ExcelColor;

/**
 * Paleta de cores de Excel
 *
 *
 * @author bbreder
 */
public abstract class PoiExcelColor {

  /**
   * Retorna o codigo da cor
   *
   * @param color
   * @return codigo da cor
   */
  public static short get(ExcelColor color) {
    switch (color) {
      case BLACK:
        return HSSFColor.BLACK.index;
      case LIGHT_BLUE:
        return HSSFColor.BLUE.index;
      case BLUE:
        return HSSFColor.BLUE.index;
      case LIGHT_GREEN:
        return HSSFColor.GREEN.index;
      case GREEN:
        return HSSFColor.GREEN.index;
      case BROWN:
        return HSSFColor.BROWN.index;
      case LIGHT_RED:
        return HSSFColor.ROSE.index;
      case RED:
        return HSSFColor.RED.index;
      case LIGHT_YELLOW:
        return HSSFColor.YELLOW.index;
      case YELLOW:
        return HSSFColor.YELLOW.index;
      case GRAY_25:
        return HSSFColor.GREY_25_PERCENT.index;
      case GRAY_50:
        return HSSFColor.GREY_50_PERCENT.index;
      case GRAY_75:
        return HSSFColor.GREY_80_PERCENT.index;
      case LIGHT_ORANGE:
        return HSSFColor.LIGHT_ORANGE.index;
      case ORANGE:
        return HSSFColor.ORANGE.index;
      case LIGHT_PINK:
        return HSSFColor.PINK.index;
      case PINK:
        return HSSFColor.PINK.index;
      case WHITE:
        return HSSFColor.WHITE.index;
      case GREEN_1:
        return HSSFColor.DARK_GREEN.index;
      case GREEN_2:
        return HSSFColor.SEA_GREEN.index;
      case GREEN_3:
        return HSSFColor.LIME.index;
      case GREEN_4:
        return HSSFColor.BRIGHT_GREEN.index;
      case GREEN_5:
        return HSSFColor.LIGHT_GREEN.index;
      case BLUE_1:
        return HSSFColor.DARK_BLUE.index;
      case BLUE_2:
        return HSSFColor.LIGHT_BLUE.index;
      case BLUE_3:
        return HSSFColor.SKY_BLUE.index;
      case BLUE_4:
        return HSSFColor.PALE_BLUE.index;
      case BLUE_5:
        return HSSFColor.BLUE.index;
    }
    return 0;
  }

}
