package tecgraf.javautils.gui.crud.gui.actions;

import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;

/**
 * Ao genrica sobre objetos.
 * 
 * @author Tecgraf
 * @param <M> tipo do objeto que representa o modelo.
 * @param <I> tipo do objeto que representa a interface.
 */
abstract public class RegistrationObjectAction<M, I> extends
  RegistrationAction<M, I> {

  /**
   * Objeto.
   */
  final private M object;

  /**
   * Retorna objeto.
   * 
   * @return objeto.
   */
  public final M getObject() {
    return object;
  }

  /**
   * Construtor
   * 
   * @param mainPanel painel
   * @param object objeto
   */
  public RegistrationObjectAction(final RegistrationMainPanel<M, I> mainPanel,
    final M object) {
    super(mainPanel);
    this.object = object;
  }
}
