package tecgraf.javautils.gui.crud.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import tecgraf.javautils.gui.crud.IRegistrationDescriptor;
import tecgraf.javautils.gui.crud.RegistrationImages;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;
import tecgraf.javautils.gui.crud.utils.RegistrationUtils;

/**
 * Ao do painel tabular
 * 
 * @author Tecgraf
 * @param <M> Model
 * @param <I> View
 */
public class RegistrationObjectDeleteAction<M, I> extends
  RegistrationObjectAction<M, I> {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    final RegistrationMainPanel<M, I> mainPanel = getMainPanel();

    final M object = getObject();
    if (object == null) {
      return;
    }

    // Confirmao de remoo: que pode ser redefinida.
    if (!confirmDeletion(mainPanel, object)) {
      return;
    }

    final IRegistrationDescriptor<M, I> descriptor = mainPanel.getDescriptor();
    final boolean deleted = descriptor.delCallback(object);
    if (deleted) {
      mainPanel.refreshGUI();
    }
  }

  /**
   * Implementao default para conformao de deleo.
   * 
   * @param mainPanel painel
   * @param object objeto.
   * @return indicativo
   */
  protected boolean confirmDeletion(RegistrationMainPanel<M, I> mainPanel,
    final M object) {
    return RegistrationUtils.confirmDeletion(mainPanel, object);
  }

  /**
   * Construtor
   * 
   * @param mainPanel painel
   * @param object objeto.
   */
  public RegistrationObjectDeleteAction(RegistrationMainPanel<M, I> mainPanel,
    M object) {
    super(mainPanel, object);
    putValue(Action.NAME, mainPanel.getString("delete.action"));
    putValue(Action.SMALL_ICON, RegistrationImages.ICON_DELETE_16);

  }
}
