package tecgraf.javautils.gui.crud.gui.editbuttons;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;

import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.crud.IRegistrationDescriptor;
import tecgraf.javautils.gui.crud.gui.edition.RegistrationEditionPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel.Mode;
import tecgraf.javautils.gui.crud.gui.main.RegistrationModeListener;

/**
 * Painel de botes.
 * 
 * @author Tecgraf
 * @param <M> tipo do objeto que representa o modelo.
 * @param <I> tipo do objeto que representa a interface.
 */
public class RegistrationEditButtonsPanel<M, I> extends JPanel {

  /**
   * Boto de cancelamento.
   */
  final private JButton cancelButton;

  /**
   * Boto de salvamento da operao.
   */
  final private JButton confirmButton;

  /**
   * Construtor
   * 
   * @param mainPanel painel
   * @param editPanel painel.
   * @param descriptor descritor
   */
  public RegistrationEditButtonsPanel(
    final RegistrationMainPanel<M, I> mainPanel,
    final RegistrationEditionPanel<M, I> editPanel,
    final IRegistrationDescriptor<M, I> descriptor) {
    this.cancelButton = new JButton(mainPanel.getString("button.cancel"));
    this.confirmButton = new JButton(mainPanel.getString("button.confirm"));

    GUIUtils.matchPreferredSizes(cancelButton, confirmButton);

    setAddModeListener(mainPanel);
    setViewModeListener(mainPanel);
    setEditModeListener(mainPanel);

    setCancelListener(mainPanel);
    setConfirmListener(mainPanel, editPanel, descriptor);

    setLayout(new FlowLayout(FlowLayout.CENTER));
    add(cancelButton);
    add(new JPanel());
    add(confirmButton);
  }

  /**
   * Ativa listener de confirmao.
   * 
   * @param mainPanel painel principal
   * @param editPanel painel de edio
   * @param descriptor descritor
   */
  private void setConfirmListener(final RegistrationMainPanel<M, I> mainPanel,
    final RegistrationEditionPanel<M, I> editPanel,
    final IRegistrationDescriptor<M, I> descriptor) {
    confirmButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        final Mode mode = mainPanel.getMode();
        switch (mode) {
          case ADD:
            final I object = editPanel.getObjectFromIHC();
            if (object == null) {
              return;
            }
            final boolean added = descriptor.addCallback(object);
            if (added) {
              mainPanel.refreshGUI();
              mainPanel.setMode(Mode.VIEW);
            }
            break;
          case EDIT:
            final M oldObj = mainPanel.getSelectedObject();
            final I newObj = editPanel.getObjectFromIHC();
            if (oldObj != null && newObj != null) {
              final boolean edited = descriptor.editCallback(oldObj, newObj);
              if (!edited) {
                return;
              }
            }
            mainPanel.refreshGUI();
            mainPanel.setMode(Mode.VIEW);
            break;
          default:
            throw new IllegalStateException("Bad mode detected!");
        }
      }
    });
  }

  /**
   * Ativa listener de cancelamento.
   * 
   * @param mainPanel painel principal
   */
  private void setCancelListener(final RegistrationMainPanel<M, I> mainPanel) {
    cancelButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        mainPanel.setMode(Mode.VIEW);
        confirmButton.setText(mainPanel.getString("button.confirm"));
      }
    });
  }

  /**
   * Ajuste de listener.
   * 
   * @param mainPanel painel
   */
  private void setAddModeListener(final RegistrationMainPanel<M, I> mainPanel) {
    mainPanel.addModeListener(new RegistrationModeListener() {
      @Override
      public void modeChanged(Mode oldMode, Mode newMode) {
        if (newMode == Mode.ADD) {
          confirmButton.setEnabled(true);
          confirmButton.setText(mainPanel.getString("button.create"));
          cancelButton.setEnabled(true);
        }
      }
    });
  }

  /**
   * Ajuste de listener.
   * 
   * @param mainPanel painel
   */
  private void setEditModeListener(final RegistrationMainPanel<M, I> mainPanel) {
    mainPanel.addModeListener(new RegistrationModeListener() {
      @Override
      public void modeChanged(Mode oldMode, Mode newMode) {
        if (newMode == Mode.EDIT) {
          //          confirmButton.setEnabled(false);
          confirmButton.setEnabled(true); // XXX - Temporrio
          confirmButton.setText(mainPanel.getString("button.confirm"));
          cancelButton.setEnabled(true);
        }
      }
    });
  }

  /**
   * Ajuste de listener.
   * 
   * @param mainPanel painel
   */
  private void setViewModeListener(final RegistrationMainPanel<M, I> mainPanel) {
    mainPanel.addModeListener(new RegistrationModeListener() {
      @Override
      public void modeChanged(Mode oldMode, Mode newMode) {
        if (newMode == Mode.VIEW) {
          confirmButton.setEnabled(false);
          cancelButton.setEnabled(false);
        }
      }
    });
  }

  /**
   * Habilita o boto de confirmar se o objeto foi editado.
   * 
   * @param flag
   */
  public void signalObjectEdited(boolean flag) {
    confirmButton.setEnabled(flag);
  }
}
