package tecgraf.javautils.gui.crud.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

import tecgraf.javautils.gui.crud.IRegistrationDescriptor;

/**
 * Renderer
 * 
 * @author Tecgraf
 * @param <M> tipo do objeto do modelo.
 * @param <I> tipo do objeto da interface.
 */
class RegistrationTableRenderer<M, I> implements TableCellRenderer {

  /**
   * Renderer default.
   */
  private static final DefaultTableCellRenderer DEFAULT_RENDERER =
    new DefaultTableCellRenderer();

  /**
   * Descritor
   */
  final private IRegistrationDescriptor<M, I> descriptor;

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int col) {
    Component renderer =
      DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected,
        hasFocus, row, col);
    final JLabel label = ((JLabel) renderer);
    if (row < 0) {
      return label;
    }

    label.setFont(renderer.getFont());
    label.setOpaque(true);
    label.setIcon(null);
    label.setToolTipText(null);
    label.setHorizontalAlignment(SwingConstants.CENTER);
    if (isSelected) {
      label.setBackground(table.getSelectionBackground());
      label.setForeground(table.getSelectionForeground());
    }
    else {
      label.setForeground(table.getForeground());
      label.setBackground(table.getBackground());
    }

    @SuppressWarnings("unchecked")
    M object = (M) table.getValueAt(row, col);
    descriptor.renderColumn(label, object, col, isSelected);

    if (!table.isEnabled()) {
      label.setForeground(Color.GRAY);
      label.setFont(label.getFont().deriveFont(Font.ITALIC));
    }
    return renderer;
  }

  /**
   * Construtor.
   * 
   * @param descriptor descritor
   */
  public RegistrationTableRenderer(
    final IRegistrationDescriptor<M, I> descriptor) {
    this.descriptor = descriptor;
  }
}
