/*
 * $Id: DefaultToolTipTableCellRenderer.java 98717 2009-11-13 17:13:17Z caduandr $
 */
package tecgraf.javautils.gui.table;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

/**
 * Renderizador que adiciona um tooltip  cada clula da tabela usando o prprio
 * valor da clula. Permite a visualizao de todo contedo da clula, que
 * poderia estar oculto caso a coluna em que ela figurar estiver muito estreita.
 * 
 * @author Tecgraf/PUC-Rio
 * 
 */
class DefaultToolTipTableCellRenderer extends DefaultTableCellRenderer {

  /** linha atual */
  private int currentRow;

  /** coluna atual */
  private int currentColumn;

  /** modelo da tabela */
  private TableModel model;

  /**
   * {@inheritDoc} Armazena as coordenadas da clula sendo renderizada, para
   * posterior uso do mtodo {@link #getToolTipText()}.
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    this.currentRow = table.convertRowIndexToModel(row);
    this.currentColumn = table.convertColumnIndexToModel(column);
    this.model = table.getModel();
    return super.getTableCellRendererComponent(table, value, isSelected,
      hasFocus, row, column);
  }

  /**
   * Atribui ao tooltip de cada clula o contedo da mesma.
   */
  @Override
  public String getToolTipText() {    
    Object value = model.getValueAt(currentRow, currentColumn);
    if (value == null) {
      return null;
    }
    return value.toString();
  }
}
