/*
 * Detalhes da ltima alterao:
 * 
 * $Author: oikawa $ $Date: 2014-02-26 16:08:39 -0300 (Wed, 26 Feb 2014) $
 * $Revision: 150399 $
 */
package tecgraf.javautils.gui.wizard;

import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;

import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.plaf.ColorUIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

import tecgraf.javautils.core.lng.LNG;

/**
 * Representa o painl com as descries dos grupos de passos que o usurio
 * percorrer.
 * 
 * @author Tecgraf/PUC-Rio
 */
final class FollowStepPanel extends JScrollPane implements WizardListener {
  /** Prefixo para o nome das chaves de traduo. */
  private static final String LNG_KEY_PREFFIX =
    FollowStepPanel.class.getName() + ".";

  /** Chava para a traduo do ttulo. */
  private static final String TITLE = "title";

  /** A largura do painel. */
  static final int PREFERRED_WIDTH = 200;

  /** O tamanho preferencial do painl. */
  private static final Dimension PREFERRED_DIMENSION =
    new Dimension(PREFERRED_WIDTH, 300);

  /** O painl onde as descries so inseridas efetivamente. */
  private JTextPane stepsTextPane;

  /** A lista de grupos de passos de onde as descries so obtidas. */
  private List stepGroupList;

  public void wasClosed(Step step) {
  }

  public void wasConfirmed(Step step, Object result) {
  }

  public void wasGoneNext(Step step, History history) {
    this.showStepsDescription(step);
  }

  public void wasGonePrevious(Step step, History history) {
    this.showStepsDescription(step);
  }

  public void wasHappenedException(Step step, WizardException exception) {
  }

  /**
   * Atualiza o painl para que identifique o passo corrente.
   * 
   * @param step O passo corrente.
   */
  private void showStepsDescription(Step step) {
    Iterator<?> stepGroupIterator = this.stepGroupList.iterator();
    StepGroup stepGroup;
    do {
      stepGroup = (StepGroup) stepGroupIterator.next();
    } while (!stepGroup.contains(step));
    showStepsDescription(stepGroup);
  }

  /**
   * Cria os estilos utilizados para exibio da descrio dos grupos de passos.
   */
  private void createStylesOnTextPane() {
    Style defaultStyle =
      StyleContext.getDefaultStyleContext()
        .getStyle(StyleContext.DEFAULT_STYLE);
    Style normalStyle =
      this.stepsTextPane.addStyle("normalStepStyle", defaultStyle);
    StyleConstants.setFontFamily(defaultStyle, "SansSerif");
    Style s = this.stepsTextPane.addStyle("currentStepStyle", normalStyle);
    StyleConstants.setItalic(s, true);
    StyleConstants.setForeground(s, new ColorUIResource(102, 102, 170));
    s = this.stepsTextPane.addStyle("titleStyle", normalStyle);
    StyleConstants.setFontSize(s, 16);
    s = this.stepsTextPane.addStyle("separator", defaultStyle);
    StyleConstants.setComponent(s, new JSeparator(
      javax.swing.SwingConstants.HORIZONTAL));
  }

  /**
   * Atualiza o painl para que identifique o grupo corrente.
   * 
   * @param currentGroup O grupo corrente.
   */
  private void showStepsDescription(StepGroup currentGroup) {
    Document doc = this.stepsTextPane.getDocument();
    int caretPosition = 0;
    try {
      doc.remove(0, doc.getLength());
      doc.insertString(doc.getLength(),
        LNG.get(LNG_KEY_PREFFIX + TITLE) + "\n", this.stepsTextPane
          .getStyle("titleStyle"));
      doc.insertString(doc.getLength(), "\n", this.stepsTextPane
        .getStyle("separator"));
      StringBuffer stepText = new StringBuffer();
      int stepIndex = 1;
      Iterator<?> stepGroupIterator = this.stepGroupList.iterator();
      while (stepGroupIterator.hasNext()) {
        StepGroup stepGroup = (StepGroup) stepGroupIterator.next();
        stepText.setLength(0);
        stepText.append("\n");
        stepText.append(String.valueOf(stepIndex));
        stepText.append(". ");
        stepText.append(stepGroup.getDescription());
        stepText.append("\n");
        if (stepGroup.equals(currentGroup)) {
          caretPosition = doc.getLength();
          doc.insertString(doc.getLength(), stepText.toString(),
            this.stepsTextPane.getStyle("currentStepStyle"));
        }
        else {
          doc.insertString(doc.getLength(), stepText.toString(),
            this.stepsTextPane.getStyle("normalStepStyle"));
        }
        stepIndex++;
      }
      this.stepsTextPane.setCaretPosition(caretPosition);
    }
    catch (BadLocationException exception) {
      IllegalStateException ise = new IllegalStateException();
      ise.initCause(exception);
      throw ise;
    }
  }

  public void wasCancelled(Step step) {
  }

  @Override
  public Dimension getPreferredSize() {
    return PREFERRED_DIMENSION;
  }

  /**
   * Cria o painl de descrio de grupos de passos.
   * 
   * @param stepGroupList Uma lista com os grupos de passos.
   */
  FollowStepPanel(List stepGroupList) {
    this.stepGroupList = stepGroupList;
    this.stepsTextPane = new JTextPane();
    this.stepsTextPane.setEditable(false);
    createStylesOnTextPane();
    getViewport().add(this.stepsTextPane);
    showStepsDescription((StepGroup) this.stepGroupList.get(0));
  }
}
