package tecgraf.javautils.gui.wizard;

import tecgraf.javautils.gui.selector.ContainerSelectionListener;

/**
 * 
 * Representa um ouvinte de eventos de mudana de estado que notifica a um passo
 * que tal evento ocorreu.
 * 
 * @author Tecgraf/PUC-Rio
 * 
 */
public final class WasChangedContainerSelectionListener implements
  ContainerSelectionListener {
  
  /** O passo que ser notificado. */
  private Step step;

  public void containerChanged() {
    this.step.notifyChanged();
  }
  
  /**
   * Cria um ouvinte de eventos de mudana de estado que notificar a um passo
   * da ocorrncia desse evento.
   *
   * @param step O passo a ser notificado.
   */
  public WasChangedContainerSelectionListener(Step step) {
    this.step = step;
  }
}
